import request5 from "@/utils/request5";


// 环境监测
export function environment(data) {
    return request5({
        url: "api/environment",
        method: "get",
        params: data
    });
}

// 获取所有设备标志
export function findAllDeviceId(companyCode) {
    return request5({
        url: "api/environment/findAllDeviceId",
        method: "get",
        params: {
            companyCode
        }
    })
}

// 获取监测数据趋势
export function analyzeTrend(companyCode, deviceId) {
    return request5({
        url: 'api/environment/analyzeTrend',
        method: "get",
        params: {
            companyCode,
            deviceId
        }
    })
}

// 降雨量
export function jiangYuLiang(data) {
    return request5({
        url: "api/wkkJiangYuLiang",
        method: "get",
        params: data
    });
}

// 浸润线
export function jinRunXian(data) {
    return request5({
        url: "api/wkkJinRunXian",
        method: "get",
        params: data
    });
}

// 干滩
export function ganTan(data) {
    return request5({
        url: "api/wkkGanTan",
        method: "get",
        params: data
    });
}

// 内部位移倾斜
export function neiBuWeiYiQingXie(data) {
    return request5({
        url: "api/neiBuWeiYiQingXie",
        method: "get",
        params: data
    });
}

// 库水位
export function kuShuiWei(data) {
    return request5({
        url: "api/wkkKuShuiWei",
        method: "get",
        params: data
    });
}

// 表面位移
export function biaoMianWeiYi(data) {
    return request5({
        url: "api/wkkBiaoMianWeiYi",
        method: "get",
        params: data
    });
}

// 尾矿库报警
export function wkkAlarmMsg(data) {
    return request5({
        url: "api/wkkAlarmMsg",
        method: "get",
        params: data
    });
}

// 人员定位
export function findPersonnelReal(data) {
    return request5({
        url: "api/personnelRealTimeData/findPersonnelReal",
        method: "get",
        params: data
    });
}

// 内部位移沉降
export function wkkNeiBuWeiYiChenJiang(data) {
    return request5({
        url: "api/wkkNeiBuWeiYiChenJiang",
        method: "get",
        params: data
    });
}


// 内部位移沉降
export function personSelectList(data) {
    return request5({
        url: "api/personnelRealTimeData/distinctCurrentBaseStationByCompanycode",
        method: "get",
        params: data
    });
}

// 人员定位统计
export function findPersonLocationStatistic(data) {
    return request5({
        url: "api/personnelRealTimeData/countEachZonePeople",
        method: "get",
        params: data
    });
}


// 尾矿库报警 新
export function wkkAlarm(data) {
    return request5({
        url: "api/alarm",
        method: "get",
        params: data
    });
}

// 降雨量 -- 获取指定企业所有监测站
export function getAllSensorNamesINJYL(companyCode) {
    return request5({
        url: "api/wkkJiangYuLiang/getAllSensorNames",
        method: "get",
        params: {
            companyCode
        }
    })
}

// 降雨量 -- 分析监测数据趋势
export function analyzeTrendINJYL(companyCode, sensorName) {
    return request5({
        url: "api/wkkJiangYuLiang/analyzeTrend",
        method: "get",
        params: {
            companyCode,
            sensorName
        }
    })
}

// 浸润线 -- 获取企业所有监测站
export function getAllSensorNamesINJRX(companyCode) {
    return request5({
        url: "api/wkkJinRunXian/getAllSensorNames",
        method: "get",
        params: {
            companyCode
        }
    })
}
// 浸润线 -- 分析监测数据趋势
export function analyzeTrendINJRX(companyCode, sensorName) {
    return request5({
        url: "api/wkkJinRunXian/analyzeTrend",
        method: "get",
        params: {
            companyCode,
            sensorName
        }
    })
}

// 库水位 -- 获取企业所有监测站
export function getAllSensorNamesINKSW(companyCode) {
    return request5({
        url: "api/wkkKuShuiWei/getAllSensorNames",
        method: "get",
        params: {
            companyCode
        }
    })
}
// 库水位 -- 分析监测数据趋势
export function analyzeTrendINKSW(companyCode, sensorName) {
    return request5({
        url: "api/wkkKuShuiWei/analyzeTrend",
        method: "get",
        params: {
            companyCode,
            sensorName
        }
    })
}

// 干滩 -- 获取企业所有监测站
export function getAllSeonsorNamesINGT(companyCode) {
    return request5({
        url: "api/wkkGanTan/getAllSensorNames",
        method: "get",
        params: {
            companyCode
        }
    })
}
// 干滩 -- 分析监测数据趋势
export function analyzeTrendINGT(companyCode, sensorName) {
    return request5({
        url: "api/wkkGanTan/analyzeTrend",
        method: "get",
        params: {
            companyCode,
            sensorName
        }
    })
}

// 表面位移 -- 获取企业所有监测站
export function getAllSensorNamesINBMWY(companyCode) {
    return request5({
        url: "api/wkkBiaoMianWeiYi/getAllSensorNames",
        method: "get",
        params: {
            companyCode
        }
    })
}
// 表面位移 -- 分析监测数据趋势
export function analyzeTrendINBMWY(companyCode, sensorName) {
    return request5({
        url: "api/wkkBiaoMianWeiYi/analyzeTrend",
        method: "get",
        params: {
            companyCode,
            sensorName
        }
    })
}

// 内部位移沉降 -- 获取指定企业所有检测站
export function getAllSensorNamesINNBWYCJ(companyCode) {
    return request5({
        url: "api/wkkNeiBuWeiYiChenJiang/getAllSensorNames",
        method: "get",
        params: {
            companyCode
        }
    })
}

// 内部位移沉降 -- 分析监测数据趋势
export function analyzeTrendINNBWYCJ(companyCode, sensorName) {
    return request5({
        url: "api/wkkNeiBuWeiYiChenJiang/analyzeTrend",
        method: "get",
        params: {
            companyCode,
            sensorName
        }
    })
}

// 内部位移倾斜 -- 获取指定企业所有监测站
export function getAllSensorNamesINNBWYQX(companyCode) {
    return request5({
        url: "api/neiBuWeiYiQingXie/getAllSensorNames",
        method: "get",
        params: {
            companyCode
        }
    })
}
// 内部位移倾斜 -- 分析监测数据趋势
export function analyzeTrendINNBWYQX(companyCode, sensorName) {
    return request5({
        url: "api/neiBuWeiYiQingXie/analyzeTrend",
        method: "get",
        params: {
            companyCode,
            sensorName
        }
    })
}