export const option = {
    backgroundColor: "#142145",
    color: ["#ffd285", "#ff733f", "#ec4863"],
    tooltip: {
        trigger: "axis"
    },
    legend: {
        x: 300,
        top: "7%",
        textStyle: {
            color: "#ffd285"
        },
        data: ["在大理", "标准版", "潍V"]
    },
    grid: {
        left: "1%",
        right: "35%",
        top: "16%",
        bottom: "6%",
        containLabel: true
    },
    toolbox: {
        show: false,
        feature: {
            saveAsImage: {}
        }
    },
    xAxis: {
        type: "category",
        axisLine: {
            lineStyle: {
                color: "#FF4500"
            }
        },
        axisTick: {
            show: false
        },
        axisLabel: {
            textStyle: {
                color: "#fff"
            }
        },
        boundaryGap: false,
        data: ["周一", "周二", "周三", "周四", "周五", "周六", "周日"]
    },
    yAxis: {
        axisLine: {
            lineStyle: {
                color: "#fff"
            }
        },
        splitLine: {
            show: true,
            lineStyle: {
                color: "#fff"
            }
        },
        axisTick: {
            show: false
        },
        axisLabel: {
            textStyle: {
                color: "#fff"
            }
        },
        type: "value"
    },
    series: [{
            name: "在大理",
            smooth: true,
            type: "line",
            symbolSize: 8,
            symbol: "circle",
            data: [90, 50, 39, 50, 120, 82, 80]
        },
        {
            name: "标准版",
            smooth: true,
            type: "line",
            symbolSize: 8,
            symbol: "circle",
            data: [70, 50, 50, 87, 90, 80, 70]
        },
        {
            name: "潍V",
            smooth: true,
            type: "line",
            symbolSize: 8,
            symbol: "circle",
            data: [290, 200, 20, 132, 15, 200, 90]
        },

        {
            type: "line",
            // 标线
            markLine: {
                data: [{
                    yAxis: 250
                }]
            }
        },

        {
            type: "pie",
            center: ["83%", "33%"],
            radius: ["25%", "30%"],
            label: {
                normal: {
                    position: "center"
                }
            },
            data: [{
                value: 335,
                name: "用户来源分析",
                itemStyle: {
                    normal: {
                        color: "#ffd285"
                    }
                },
                label: {
                    normal: {
                        formatter: "{d} %",
                        textStyle: {
                            color: "#ffd285",
                            fontSize: 20
                        }
                    }
                }
            }]
        },

        {
            type: "pie",
            center: ["83%", "72%"],
            radius: ["25%", "30%"],
            label: {
                normal: {
                    position: "center"
                }
            },
            data: [{
                value: 435,
                name: "用户来源分析",
                itemStyle: {
                    normal: {
                        color: "#ff733f"
                    }
                },
                label: {
                    normal: {
                        formatter: "{d} %",
                        textStyle: {
                            color: "#ff733f",
                            fontSize: 20
                        }
                    }
                }
            }]
        }
    ]
};

