import axios from 'axios'

import {
    Message,
    Notification
} from 'element-ui';

const service = axios.create({
    baseURL: 'http://39.98.150.124:9875/',
    // baseURL: 'http://192.168.1.132:9875/',
    // baseURL: process.env.NODE_ENV === "production" ?
    // "http://192.168.100.224:9875/" : "/index", // api 的 base_url
    timeout: 30000
})


// 请求前拦截
service.interceptors.request.use(config => {

    if (!config.headers['token']) {
        config.headers['Authorization'] = 'Bearer eyJhbGciOiJIUzUxMiJ9.eyJqdGkiOiIyYmUyNmEzZTg3Njc0NzAwYjQyODY2YjgzNmQwZDQ5OSIsInVzZXIiOiJhZG1pbiIsInN1YiI6ImFkbWluIn0.qlg04WGthnLo0ugvJtKBmJQXNEuxqT3F9bZDdF_iWHvx-YRsWtNY9DUZW-HOC0F_I2dCMsXVtVmed7NcBIItqA'
    }

    return config;
}, )

service.interceptors.response.use(
    response => {
        return response.data;
    },

    error => {
        if (error.response.status) {
            const responseCode = error.response.status

            switch (responseCode) {

                case 400:

                    // Message.error('操作失败');

                    break;

                    //  token 过期 
                case 401:

                    Notification({
                        title: '登录过期，请重新登录',
                        duration: 2000,
                        type: 'warning'
                    });

                    setTimeout(() => {
                        window.localStorage.removeItem('token');
                        window.location = '#/'
                    }, 1000)

                    break;

                default:

                    break
            }
            return error.response.data;
        }
    }

)

export default service;