import axios from 'axios'
//import router from '@/router/routers'
//import Config from '@/config'

import { Message, Notification } from 'element-ui'

const service = axios.create({
    //## baseURL: 'http://39.98.150.124:8000/',
	//## timeout: 30000,
	baseURL: process.env.NODE_ENV === 'production' ? process.env.BASE_API : '/', // api 的 base_url
	timeout: 30000,
})

service.interceptors.response.use(
	response => {
		return response.data
	},

	error => {
		if (error.response.status) {
			const responseCode = error.response.status

			switch (responseCode) {
				case 400:
					// Message.error('操作失败');

					break

				//  token 过期
				case 401:
					Notification({
						title: '登录过期，请重新登录',
						duration: 2000,
						type: 'warning',
					})

					setTimeout(() => {
						window.localStorage.removeItem('token')
						window.location = '#/'
					}, 1000)

					break

				default:
					break
			}
			return error.response.data
		}
	}
)

export default service
