import axios from 'axios'

import { Message, Notification } from 'element-ui'

const service = axios.create({
	// baseURL: 'http://192.168.3.216:8000/', // 大龙
	// baseURL: 'http://192.168.1.123:8000/', //小葱
    // baseURL: 'http://120.224.103.84:9111/',
	baseURL: 'http://10.185.163.57:8000/',


	timeout: 30000,
})

service.interceptors.response.use(
	response => {
		return response.data
	},

	error => {
		if (error.response.status) {
			const responseCode = error.response.status

			switch (responseCode) {
				case 400:
					// Message.error('操作失败');

					break

				//  token 过期
				case 401:
					Notification({
						title: '登录过期，请重新登录',
						duration: 2000,
						type: 'warning',
					})

					setTimeout(() => {
						window.localStorage.removeItem('token')
						window.location = '#/'
					}, 1000)

					break

				default:
					break
			}
			return error.response.data
		}
	}
)

export default service
