import Vue from 'vue'
import Vuex from 'vuex'
import {
  dictDetail
} from '@/api'



Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    title: '',
    appMap: '', // 地图
    mouseTool: '', // 面积测量
    appTileLayer: '', // 
    select_item: [], // 选项卡
    isLeft: false, // 显示 左边栏
    isRight: false, // 显示 右边栏

    deptData: [], // 所有企业

    isLtkDialog: false, // 露天矿 弹框
    isDxkqDialog: false, // 地下矿区 弹框

    compony_info: '', // 企业信息
    BaseLeftIndex: 1, // 判断模块
    is_show_huan_jing_jian_ce: false, // 尾矿库环境监测
    is_show_huan_jing_jian_ce_table: false, // 尾矿库环境监测表格


    showItemCharts: false,  // 尾矿库六大项可视化
    
    showSaleItem1: false,
    showSaleItem2: false,
    showSaleItem3: false,
    showSaleItem4: false,
    showSaleItem5: false,
    showSaleItem6: false,
    showSaleItem7: false,
    
    isShowEnterPortrait: false,

    curVideoUrl: '',
    curIsVideo: false,
    curVideoShow: false




  },
  mutations: {

    SET_VideoUrl(state, url) {
      state.curVideoUrl = url
    },

    SET_IsVideo(state, isVideo) {
      state.curIsVideo = isVideo
    },

    SET_VideoShow(state, isVideoShow) {
      state.curVideoShow = isVideoShow
    },

    // 企业类型
    SET_TYPE(state, value) {
      state.select_item = value
    },  

    // 获取所有企业
    SET_deptData(state, value) {
      state.deptData = value
    },

    SET_TITLE(state, value) {
      state.title = value;
    },

    SET_IS_LEFT(state, value) {
      state.isLeft = value
    },

    SET_IS_Right(state, value) {
      state.isRight = value
    },

    SET_APP_MAP(state, value) {
      state.appMap = value
    },

    SET_MOUSETOOL(state, value) {
      state.mouseTool = value
    },

    set_appTileLayer(state, value) {
      state.appTileLayer = value
    },

    set_compony_info(state, value) {
      state.compony_info = value
    },

    set_BaseLeftIndex(state, value) {
      state.BaseLeftIndex = value
    },

    set_isLtkDialog(state, value) {
      state.isLtkDialog = value
    },

    set_isDxkqDialog(state, value) {
      state.isDxkqDialog = value
    },

    // 尾矿库环境监测
    set_is_show_huan_jing_jian_ce(state, value) {
      state.is_show_huan_jing_jian_ce = value
    },
    // 尾矿库环境监测表格
    set_is_show_huan_jing_jian_ce_table(state, value) {
      state.is_show_huan_jing_jian_ce_table = value
    },

    setShowItemCharts(state, value) {
      state.showItemCharts = value
    },

    SET_EnterPotrait(state, value) {
      state.isShowEnterPortrait = value
    },

    // 显示 销售监测项1
    SET_SALE_ITEM1(state, value) {
      console.log("SET_SALE_ITEM1!", value, "hehe")
      state.showSaleItem1 = value
      state.showSaleItem2 = false
      state.showSaleItem3 = false
      state.showSaleItem4 = false
      state.showSaleItem5 = false
      state.showSaleItem6 = false
      state.showSaleItem7 = false
    },
    // 显示 销售监测项2
    SET_SALE_ITEM2(state, value) {
      state.showSaleItem1 = false
      state.showSaleItem2 = value
      state.showSaleItem3 = false
      state.showSaleItem4 = false
      state.showSaleItem5 = false
      state.showSaleItem6 = false
      state.showSaleItem7 = false
    },
    // 显示 销售监测项3
    SET_SALE_ITEM3(state, value) {
      state.showSaleItem1 = false
      state.showSaleItem2 = false
      state.showSaleItem3 = value
      state.showSaleItem4 = false
      state.showSaleItem5 = false
      state.showSaleItem6 = false
      state.showSaleItem7 = false
    },
    // 显示 销售监测项4
    SET_SALE_ITEM4(state, value) {
      state.showSaleItem1 = false
      state.showSaleItem2 = false
      state.showSaleItem3 = false
      state.showSaleItem4 = value
      state.showSaleItem5 = false
      state.showSaleItem6 = false
      state.showSaleItem7 = false
    },
    // 显示 销售监测项4
    SET_SALE_ITEM5(state, value) {
      state.showSaleItem1 = false
      state.showSaleItem2 = false
      state.showSaleItem3 = false
      state.showSaleItem4 = false
      state.showSaleItem5 = value
      state.showSaleItem6 = false
      state.showSaleItem7 = false
    },
    SET_SALE_ITEM6(state, value) {
      state.showSaleItem1 = false
      state.showSaleItem2 = false
      state.showSaleItem3 = false
      state.showSaleItem4 = false
      state.showSaleItem5 = false
      state.showSaleItem6 = value
      state.showSaleItem7 = false
    },
    SET_SALE_ITEM7(state, value) {
      state.showSaleItem1 = false
      state.showSaleItem2 = false
      state.showSaleItem3 = false
      state.showSaleItem4 = false
      state.showSaleItem5 = false
      state.showSaleItem6 = false
      state.showSaleItem7 = value
    },

  },

  actions: {

    // 企业类型
    typeOptions({
      commit
    }, userinfo) {
      const params = {
        page: 0,
        size: 999,
        sort: 'dictSort,asc',
        sort: 'id,desc',
        dictName: '所属行业',
      }
      dictDetail(params).then(res => {
        let select_item = res.content.map(item => {
          return {
            value: item.label,
            label: item.label,
            id: item.id
          }
        })

        commit('SET_TYPE', select_item)

      })
    }

  }


})