import request5 from "@/utils/request5";

export function monitorDevice(deptId) {
  return request5({
    url: '/api/sensor/monitor',
    method: 'get',
    params: {
      deptId
    }
  })
}

export function monitorData(companycode) {
  return request5({
    url: '/api/dataInfo/monitor',
    method: 'get',
    params: {
      companycode
    }
  })
}

export function analyzeAlarmNum(companycode) {
  return request5({
    url: '/api/alarm/analyzeNum',
    method: 'get',
    params: {
      companycode
    }
  })
}


export function analyzeHDNum(deptId) {
  return request5({
    url: '/api/hiddenDanger/analyzeNum',
    method: 'get',
    params: {
      deptId
    }
  })
}

export function sensorAlarmNum(deptId) {
  // return request5({
  //   url: '/api/sensor/analyzeAlarmNum',
  //   method: 'get',
  //   params: {
  //     deptId
  //   }
  // })
  return request5({
    url: '/api/sensor/monitor',
    method: 'get',
    params: {
      deptId
    }
  })
}

export function createInfoCard(deptId) {
  return request5({
    url: '/api/alarm/createInfoCard',
    method: 'get',
    params: {
      deptId
    }
  })
}

// 隐患趋势
export function analyzeOutputTrend() {
  return request5({
    url: '/api/output/analyzeOutputTrend',
    method: 'get'
  })
}

// 重大安全隐患统计
export function  analyzeEachMonthNum(level) {
  return request5({
    url: '/api/hiddenDanger/analyzeEachMonthNum',
    method: 'get',
    params: {
      level
    }
  })
}

// 企业- 分析各等级风险数量
export function analyzeEnterRiskNum(deptId) {
  return request5({
    url: '/api/dept/analyzeEachRiskLevelNum',
    method: 'get',
    params: {
      deptId
    }
  })
}
// 行业- 分析各等级风险数量
export function analyzeIndusRiskNum(detailId) {
  return request5({
    url: '/api/dictDetail/analyzeEachRiskLevelNum',
    method: 'get',
    params: {
      detailId
    }
  })
}
// 区域- 分析各等级风险数量
export function analyzeRegionRiskNum() {
  return request5({
    url: '/api/areaRiskLevel/analyzeEachRiskLevelNum',
    method: 'get'
  })
}
