const {
    BundleAnalyzerPlugin
} = require('webpack-bundle-analyzer');

const CopyWebpackPlugin = require('copy-webpack-plugin');


module.exports = {
    publicPath: './',
    outputDir: 'web',
    assetsDir: 'static',
    productionSourceMap: false, //，系统就不会自动生成 map文件了

    devServer: {
        disableHostCheck: true
    },

	// vue-cli3 配置举例， vue.config.js中
	devServer: {
		proxy: {
			// 天气接口
			'/weather': {
				target: 'http://i.tianqi.com/',  // 真实请求URl
				changeOrigin: true, // 允许跨域
				pathRewrite: {  // 替换，通配/api的替换成/
					'^/weather': '/'
				}
			},
		}
	},

    // devServer: {
    //     proxy: {
    //         '/index': {
    //             target: 'http://39.98.150.124/', //后端接口地址
    //             changeOrigin: true, //是否允许跨越
    //             pathRewrite: {
    //                 '^/index': '', //重写,
    //             }
    //         }
    //     },
    // },

    // 安装第三方插件,配置CDN
    configureWebpack: {
        externals: {
            "echarts": "echarts"
        },

        plugins: [
            new CopyWebpackPlugin(
                
                [
                    { from: 'node_modules/@liveqing/liveplayer/dist/component/crossdomain.xml'},
                    { from: 'node_modules/@liveqing/liveplayer/dist/component/liveplayer-lib.min.js', to: 'js/'},
                    { from: 'node_modules/@liveqing/liveplayer/dist/component/liveplayer.swf'}
                ]
            
            )
        ]
    },


    // chainWebpack: config => {
    //     config
    //         .plugin('webpack-bundle-analyzer')
    //         .use(require('webpack-bundle-analyzer').BundleAnalyzerPlugin)
    // }


}