import Vue from "vue";
import Router from "vue-router";
import HomeLayout from "../layout/home";

Vue.use(Router);

export const constantRouterMap = [
	{
		path: "/404",
		redirect: "/edge/Screen",
		component: resolve => {
			require(["@/views/features/404"], resolve)
		},
		hidden: true
	},
	{
		path: "/401",
		component: resolve => require(["@/views/features/401"], resolve),
		hidden: true
	},
	{
		path: "/user",
		//component: Layout,
		component: HomeLayout,
		hidden: true,
		redirect: "noredirect",
		children: [
			{
				path: "center",
				component: resolve => require(["@/views/system/user/center"], resolve),
				name: "个人中心",
				meta: { title: "个人中心" }
			}
		]
	},
	{
		path: "/edge/Screen",
		component: (resolve) => {
			return require(["@/views/Screen/index"], resolve)
		},
		hidden: true
	},
	
	{
		path: "/",
		//redirect: "/edge/Screen",
		component: (resolve) => {
			window.location.href = '/edge/Screen'
		},
		hidden: true
	},
];

if(process.env.NODE_ENV === 'development'){
	constantRouterMap.push({
		path: "/edge/ScreenTest",
		component: (resolve) => {
			return require(["@/views/Screen/indexTest"], resolve)
		},
		hidden: true
	});
};

export default new Router({
    // mode: 'hash',
    mode:"history",
	//base: '/mobile/',
    scrollBehavior: () => ({ y: 0 }),
    routes: constantRouterMap
});
