import axios from 'axios'
import { Notification } from 'element-ui'
import { getToken } from '@/utils/auth'
import Config from '@/settings'

//const settings = require('@/../static/config/settings');

// 使请求头可以携带cookie
axios.defaults.withCredentials = true;

//var baseURL = (VUE_APP_API.ServiceURL || process.env.VUE_APP_LOCAL_API) + '/';
var baseURL = process.env.NODE_ENV
 === 'development' ? process.env.VUE_APP_LOCAL_API + '/' : (VUE_APP_API.ServiceURL || process.env.VUE_APP_LOCAL_API) + '/';

// 创建axios实例
const service = axios.create({
	baseURL: baseURL,
	timeout: Config.timeout // 请求超时时间
})

// request拦截器
service.interceptors.request.use(
	config => {
		var token = getToken();
		var Token = token && (token !== typeof(void 0)) && token || config.token;
		if (Token) {
			config.headers['Authorization'] = Token // 让每个请求携带自定义token 请根据实际情况自行修改
		}
		config.headers['Content-Type'] = 'application/json'
		return config
	},
	error => {
		Promise.reject(error)
	}
)

// response 拦截器
service.interceptors.response.use(
	response => {
		return response.data
	},
	error => {
		if (error.response.status) {
			const responseCode = error.response.status;
			
			/*
			switch (responseCode) {
				case 400:
				  // Message.error('操作失败');

				  break

				  //  token 过期
				case 401:
					Notification({
						title: '登录过期，请重新登录',
						duration: 2000,
						type: 'warning'
					})

					setTimeout(() => {
						window.localStorage.removeItem('token')
						window.location = '#/';
						location.reload()
					}, 1000)

					break

				default:
				  break
			}*/
			return error.response.data
		}
	}
)
export default service
