import request from '@/utils/request'

export default {
  /**
   * 用户-文件夹 权限分配
   */
  // 获取用户List
  getDataList4User: (pageParam) => {
    return request({
      url: 'api/users',
      method: 'get',
      params: pageParam
    })
  },

  saveFolderAuth: (data) => {
    return request({
      url: 'api/document-catalogue/distributionCatalogue',
      method: 'post',
      data
    })
  },



  /**
   * 目录-文件 显示页面
   * @param {*} pageParam 
   * @returns 
   */
  // 获取所有目录
  getDataList: (pageParam) => {
    return request({
      // url: 'api/document-catalogue/all',
      url: 'api/document-catalogue/tree',
      method: 'get',
      params: pageParam
    })
  },
    /**
   * 目录-文件 显示页面
   * @param {*} pageParam 
   * @returns 
   */
  // 获取所有目录
  getAllDocList: (pageParam) => {
    return request({
      url: 'api/document-catalogue/all',
      // url: 'api/document-catalogue/tree',
      method: 'get',
      params: pageParam
    })
  },
   // 新增目录
   addFolder: (data) => {
    return request({
      url: 'api/document-catalogue',
      method: 'post',
      data
    })
  },
    // 新增目录
    delFolder: (ids) => {
      return request({
        url: 'api/document-catalogue',
        method: 'delete',
        data: ids
      })
    },
  // 修改文件夹名称: (iotNormalMachine) => {
    
  updateFolder: (data) => {
    return request({
      url: 'api/document-catalogue',
      method: 'put',
      data
    })
  },
  // 查看目录文件列表
  getfileByFolderId: (params) => {
    return request({
      url: 'api/document/catalogueId',
      method: 'get',
      params
    })
  },
  // 新增目录-文件
  addFileByFolderId: (data) => {
    return request({
      url: 'api/document',
      method: 'post',
      data
    })
  },
  // 删除
  delFileById: (ids) => {
    return request({
      url: 'api/document',
      method: 'delete',
      data: ids
    })
  },
  // 根据企业查询所属矿山（含停产）enterpriseId
  getAllMineByEnterpriseId: (mineSearchParam) => {
    return request({
      url: 'api/mine/all-mine/list',
      method: 'get',
      params: mineSearchParam
    })
  }
  

}
