import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/emergency-plan/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/emergency-plan/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/emergency-plan/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (emergencyPlan) => {
    return request({
      url: 'api/emergency-plan/add',
      method: 'post',
      data: emergencyPlan
    })
  },
  // 修改
  set: (emergencyPlan) => {
    emergencyPlan.enterpriseId = null
    emergencyPlan.mineType = null
    emergencyPlan.mineId = null
    emergencyPlan.createDatetime = null
    emergencyPlan.createBy = null
    emergencyPlan.updateDatetime = null
    emergencyPlan.updateBy = null
    return request({
      url: 'api/emergency-plan/set',
      method: 'post',
      data: emergencyPlan
    })
  },
  // 删除
  del: (emergencyPlan) => {
    return request({
      url: 'api/emergency-plan/del',
      method: 'post',
      data: {
        id: emergencyPlan.id
      }
    })
  }
}
