import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/emergency-supplies/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/emergency-supplies/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/emergency-supplies/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (emergencySupplies) => {
    return request({
      url: 'api/emergency-supplies/add',
      method: 'post',
      data: emergencySupplies
    })
  },
  // 修改
  set: (emergencySupplies) => {
    emergencySupplies.enterpriseId = null
    emergencySupplies.mineType = null
    emergencySupplies.mineId = null
    emergencySupplies.createDatetime = null
    emergencySupplies.createBy = null
    emergencySupplies.updateDatetime = null
    emergencySupplies.updateBy = null
    return request({
      url: 'api/emergency-supplies/set',
      method: 'post',
      data: emergencySupplies
    })
  },
  // 删除
  del: (emergencySupplies) => {
    return request({
      url: 'api/emergency-supplies/del',
      method: 'post',
      data: {
        id: emergencySupplies.id
      }
    })
  }
}
