import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/emergency-team/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/emergency-team/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/emergency-team/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (emergencyTeam) => {
    return request({
      url: 'api/emergency-team/add',
      method: 'post',
      data: emergencyTeam
    })
  },
  // 修改
  set: (emergencyTeam) => {
    emergencyTeam.enterpriseId = null
    emergencyTeam.mineType = null
    emergencyTeam.mineId = null
    emergencyTeam.createDatetime = null
    emergencyTeam.createBy = null
    emergencyTeam.updateDatetime = null
    emergencyTeam.updateBy = null
    return request({
      url: 'api/emergency-team/set',
      method: 'post',
      data: emergencyTeam
    })
  },
  // 删除
  del: (emergencyTeam) => {
    return request({
      url: 'api/emergency-team/del',
      method: 'post',
      data: {
        id: emergencyTeam.id
      }
    })
  }
}
