import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/iot-person-card/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/iot-person-card/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/iot-person-card/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (iotPersonCard) => {
    return request({
      url: 'api/iot-person-card/add',
      method: 'post',
      data: iotPersonCard
    })
  },
  // 修改
  set: (iotPersonCard) => {
    iotPersonCard = JSON.parse(JSON.stringify(iotPersonCard))

    iotPersonCard.enterpriseId = null
    iotPersonCard.mineType = null
    iotPersonCard.mineId = null
    iotPersonCard.createDatetime = null
    iotPersonCard.createBy = null
    iotPersonCard.updateDatetime = null
    iotPersonCard.updateBy = null

    iotPersonCard.code = null
    return request({
      url: 'api/iot-person-card/set',
      method: 'post',
      data: iotPersonCard
    })
  },
  // 删除
  del: (iotPersonCard) => {
    return request({
      url: 'api/iot-person-card/del',
      method: 'post',
      data: {
        id: iotPersonCard.id
      }
    })
  }
}
