import request from '@/utils/request'

export default {
  // 测点类型s
  monitoringTypes: () => {
    return [
      { code: '01', name: '干滩长度' },
      { code: '02', name: '库水位' },
      { code: '03', name: '表面位移' },
      { code: '04', name: '内部位移' },
      { code: '05', name: '浸润线' },
      { code: '06', name: '降雨量' },
      { code: '07', name: '库区地质滑坡体表面位移' }
    ]
  },
  // 获取测点类型
  getMonitoringTypeByCode(code) {
    if (code && code.length >= 12) {
      const letCode = code.substring(10, 12)
      const pointTypes = this.monitoringTypes()
      for (const pIndex in pointTypes) {
        if (letCode === pointTypes[pIndex].code) {
          return pointTypes[pIndex]
        }
      }
    }
    return null
  },
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/iot-normal-machine/tailings/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/iot-normal-machine/tailings/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/iot-normal-machine/tailings/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (iotNormalMachine) => {
    return request({
      url: 'api/iot-normal-machine/tailings/add',
      method: 'post',
      data: iotNormalMachine
    })
  },
  // 修改
  set: (iotNormalMachine) => {
    // iotNormalMachine.enterpriseId = null
    // iotNormalMachine.mineType = null
    // iotNormalMachine.mineId = null
    iotNormalMachine.createDatetime = null
    iotNormalMachine.createBy = null
    iotNormalMachine.updateDatetime = null
    iotNormalMachine.updateBy = null
    iotNormalMachine.hasEnable = null
    iotNormalMachine.code = null
    iotNormalMachine.useType = null
    return request({
      url: 'api/iot-normal-machine/tailings/set',
      method: 'post',
      data: iotNormalMachine
    })
  },
  // 删除
  del: (iotNormalMachine) => {
    return request({
      url: 'api/iot-normal-machine/tailings/del',
      method: 'post',
      data: {
        id: iotNormalMachine.id
      }
    })
  }
}
