import request from '@/utils/request'

export default {
  // 查询监控与矿山的关联关系
  getLink: (mineVideoParam) => {
    return request({
      url: 'api/video/link-mine',
      method: 'get',
      params: mineVideoParam
    })
  },
  // 绑定关联关系
  link: (mineVideo) => {
    return request({
      url: 'api/video/link-mine',
      method: 'post',
      data: mineVideo
    })
  },
  // 刷新监控信息
  refreshLink: (mineVideo) => {
    return request({
      url: 'api/video/refresh-link',
      method: 'post',
      data: mineVideo
    })
  },
  // 报警查询
  getWarnPage: (pageParam) => {
    return request({
      url: 'api/video-ai/page',
      method: 'get',
      params: pageParam
    })
  },
  delBatch: (delParam) => {
    return request({
      url: 'api/video-ai/delete-batch',
      method: 'post',
      data: delParam
    })
  }
}
