import axios from 'axios'
import router from '@/router/routers'
import { Notification } from 'element-ui'
import store from '../store'
import { getToken } from '@/utils/auth'
import Config from '@/settings'
import Cookies from 'js-cookie'

    /**
       * 矿产信息固定值
       
       */
    // localStorage.setItem(
    //   "kd.selected.mine",
    //   JSON.stringify({
    //     address: "测试地址",
    //     code: "1452562",
    //     enterpriseId: 1,
    //     hasEnable: true,
    //     id: 1,
    //     latitude: "37.05",
    //     liablePerson: "人员",
    //     liablePersonPhone: "15455248718",
    //     longitude: "117.74",
    //     mineType: 1,
    //     name: "测试地下矿山",
    //     runState: null,
    //   })
    // );

var baseURL = process.env.NODE_ENV
 === 'development' ? process.env.VUE_APP_LOCAL_API + '/' : (process.env.VUE_APP_LOCAL_API) + '/';

 console.log('process.env.VUE_APP_BASE_API ________________ ', process.env.VUE_APP_BASE_API);

// 创建axios实例
const service = axios.create({
  baseURL: baseURL,
  timeout: Config.timeout // 请求超时时间
})


 console.log('service ________________ ', service);


// request拦截器
service.interceptors.request.use(
  config => {
    if (getToken()) {
      config.headers['Authorization'] = getToken() // 让每个请求携带自定义token 请根据实际情况自行修改
    }
    config.headers['Content-Type'] = 'application/json'

    if (config.method) {
      let method = config.method.toLowerCase()
      if (method && method != 'get' && method != 'post') {
        config.method = 'post'
        if (!config.params) {
          config.params = {}
        }
        config.params['_method'] = method
      }
    }
    return config
  },
  error => {
    Promise.reject(error)
  }
)

// response 拦截器
service.interceptors.response.use(
  response => {
    return response.data
  },
  error => {
    // 兼容blob下载出错json提示
    if (error.response.data instanceof Blob && error.response.data.type.toLowerCase().indexOf('json') !== -1) {
      const reader = new FileReader()
      reader.readAsText(error.response.data, 'utf-8')
      reader.onload = function (e) {
        const errorMsg = JSON.parse(reader.result).message
        Notification.error({
          title: errorMsg,
          duration: 5000
        })
      }
    } else {
      let code = 0
      try {
        code = error.response.data.status
      } catch (e) {
        if (error.toString().indexOf('Error: timeout') !== -1) {
          Notification.error({
            title: '网络请求超时',
            duration: 5000
          })
          return Promise.reject(error)
        }
      }
      console.log(code)
      if (code) {
        if (code === 401) {
          store.dispatch('LogOut').then(() => {
            // 用户登录界面提示
            Cookies.set('point', 401)
            location.reload()
          })
        } else if (code === 403) {
          router.push({ path: '/401' })
        } else {
          const errorMsg = error.response.data.message
          if (errorMsg !== undefined) {
            Notification.error({
              title: errorMsg,
              duration: 5000
            })
          }
        }
      } else {
        Notification.error({
          title: '服务器连接超时',
          duration: 5000
        })
      }
    }
    return Promise.reject(error)
  }
)
export default service
