import request from '@/utils/request'

export default {
  // 类型
  types: () => {
    return [{
      key: 1, value: '限制区域'
    }, {
      key: 2, value: '重点区域'
    }, {
      key: 3, value: '井口区域'
    }, {
      key: 4, value: '其他区域'
    }]
  },
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/iot-person-area/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/iot-person-area/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/iot-person-area/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (iotPersonArea) => {
    return request({
      url: 'api/iot-person-area/add',
      method: 'post',
      data: iotPersonArea
    })
  },
  // 修改
  set: (iotPersonArea) => {
    iotPersonArea = JSON.parse(JSON.stringify(iotPersonArea))

    iotPersonArea.enterpriseId = null
    iotPersonArea.mineType = null
    iotPersonArea.mineId = null
    iotPersonArea.createDatetime = null
    iotPersonArea.createBy = null
    iotPersonArea.updateDatetime = null
    iotPersonArea.updateBy = null

    iotPersonArea.code = null
    return request({
      url: 'api/iot-person-area/set',
      method: 'post',
      data: iotPersonArea
    })
  },
  // 删除
  del: (iotPersonArea) => {
    return request({
      url: 'api/iot-person-area/del',
      method: 'post',
      data: {
        id: iotPersonArea.id
      }
    })
  }
}
