import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/leader-classes/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/leader-classes/page',
      method: 'get',
      params: pageParam
    })
  },
  // 新增
  add: (leaderClasses) => {
    return request({
      url: 'api/leader-classes/add',
      method: 'post',
      data: leaderClasses
    })
  },
  // 修改
  set: (leaderClasses) => {
    leaderClasses.enterpriseId = null
    leaderClasses.mineType = null
    leaderClasses.mineId = null
    leaderClasses.createDatetime = null
    leaderClasses.createBy = null
    leaderClasses.updateDatetime = null
    leaderClasses.updateBy = null
    leaderClasses.hasEnable = null
    return request({
      url: 'api/leader-classes/set',
      method: 'post',
      data: leaderClasses
    })
  },
  // 设置启停
  setEnable: (leaderClasses) => {
    return request({
      url: 'api/leader-classes/set-enable',
      method: 'post',
      data: leaderClasses
    })
  },
  // 删除
  del: (leaderClasses) => {
    return request({
      url: 'api/leader-classes/del',
      method: 'post',
      data: {
        id: leaderClasses.id
      }
    })
  }
}
