import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/leader-scheduling/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/leader-scheduling/page',
      method: 'get',
      params: pageParam
    })
  },
  // all查询
  getAll: (pageParam) => {
    return request({
      url: 'api/leader-scheduling/all',
      method: 'get',
      params: pageParam
    })
  },
  // 导出（getAll演变来）
  export: (pageParam) => {
    return request({
      url: 'api/leader-scheduling/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (leaderScheduling) => {
    return request({
      url: 'api/leader-scheduling/add',
      method: 'post',
      data: leaderScheduling
    })
  },
  // 新增多日带班
  addMoreDate: (leaderSchedulingAndDateFromTo) => {
    return request({
      url: 'api/leader-scheduling/add-more-date',
      method: 'post',
      data: leaderSchedulingAndDateFromTo
    })
  },
  // 修改
  set: (leaderScheduling) => {
    leaderScheduling.enterpriseId = null
    leaderScheduling.mineType = null
    leaderScheduling.mineId = null
    leaderScheduling.createDatetime = null
    leaderScheduling.createBy = null
    leaderScheduling.updateDatetime = null
    leaderScheduling.updateBy = null
    return request({
      url: 'api/leader-scheduling/set',
      method: 'post',
      data: leaderScheduling
    })
  },
  // 删除
  del: (leaderScheduling) => {
    return request({
      url: 'api/leader-scheduling/del',
      method: 'post',
      data: {
        id: leaderScheduling.id
      }
    })
  },
  // 申请变更
  applyChange: (change) => {
    return request({
      url: 'api/leader-scheduling/change/apply',
      method: 'post',
      data: change
    })
  },
  // 审核变更
  auditChange: (change) => {
    return request({
      url: 'api/leader-scheduling/change/audit',
      method: 'post',
      data: change
    })
  },
  // 分页查询变更
  getChangePage: (pageParam) => {
    return request({
      url: 'api/leader-scheduling/change/page',
      method: 'get',
      params: pageParam
    })
  },
  // 分页查询变更
  exportChange: (pageParam) => {
    return request({
      url: 'api/leader-scheduling/change/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  }
}
