import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/staff/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/staff/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/staff/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 导出
  exportSpecialInfo: (pageParam) => {
    return request({
      url: 'api/staff/special-info/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (staff) => {
    return request({
      url: 'api/staff/add',
      method: 'post',
      data: staff
    })
  },
  // 修改
  set: (staff) => {
    staff.enterpriseId = null
    staff.mineType = null
    staff.mineId = null
    staff.createDatetime = null
    staff.createBy = null
    staff.updateDatetime = null
    staff.updateBy = null
    return request({
      url: 'api/staff/set',
      method: 'post',
      data: staff
    })
  },
  // 移除人员的特殊岗位信息
  removeSpecialInfo: (staff) => {
    return request({
      url: 'api/staff/remove-special-info',
      method: 'post',
      data: staff
    })
  },
  // 删除
  del: (staff) => {
    return request({
      url: 'api/staff/del',
      method: 'post',
      data: {
        id: staff.id
      }
    })
  }
}
