import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/staff-department/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/staff-department/page',
      method: 'get',
      params: pageParam
    })
  },
  // 新增
  add: (staffDepartment) => {
    return request({
      url: 'api/staff-department/add',
      method: 'post',
      data: staffDepartment
    })
  },
  // 修改
  set: (staffDepartment) => {
    staffDepartment.enterpriseId = null
    staffDepartment.mineType = null
    staffDepartment.mineId = null
    staffDepartment.createDatetime = null
    staffDepartment.createBy = null
    staffDepartment.updateDatetime = null
    staffDepartment.updateBy = null
    return request({
      url: 'api/staff-department/set',
      method: 'post',
      data: staffDepartment
    })
  },
  // 删除
  del: (staffDepartment) => {
    return request({
      url: 'api/staff-department/del',
      method: 'post',
      data: {
        id: staffDepartment.id
      }
    })
  }
}
