import request from '@/utils/request'
export default {
  getkdFile: (pageParam) => {
    return request({
      url: 'api/kdFile',
      method: 'get',
      params: pageParam
    })
  },
  // 新增
  add: (notice) => {
    return request({
      url: 'api/notice/add',
      method: 'post',
      data: notice
    })
  },
  // 标记已读（查询权限）
  read: (responseId) => {
    return request({
      url: 'api/notice/read',
      method: 'post',
      data: {
        id: responseId
      }
    })
  },
  // 删除
  del: (notice) => {
    return request({
      url: 'api/notice/del',
      method: 'post',
      data: {
        id: notice.id
      }
    })
  }
}