import request from '@/utils/request'

export default {
  // 绑定我的
  addMy: (iotMachine) => {
    return request({
      url: 'api/iot-machine/add/my',
      method: 'post',
      data: iotMachine
    })
  },
  // 移除我的
  removeMy: () => {
    return request({
      url: 'api/iot-machine/remove-all/my',
      method: 'post'
    })
  },
  // 查询我的
  getDataList:(params) => {
    return request({
      url: 'data/mp/history',
      method: 'get',
      params
    })
  },
  // 查询风速、温度
    getDataList4windSpeed: (params) => {
    return request({
      url: 'data/sz/history',
      method: 'get',
      params
    })
  },
  // 查询降雨量
  getDataList4waterPrecipitation: (params) => {
    return request({
      url: 'data/rg/history',
      method: 'get',
      params
    })
  },
  // 报警列表
  drybeachequipinforalarmList: (params) => {
    return request({
      url: 'tab/drybeachequipinfor/alarmList',
      method: 'get',
      params
    })
  },
  //确认忽略报警
  drybeachequipinforalarmListput: (params) => {
    return request({
      url: 'tab/drybeachequipinfor/alarmList',
      method: 'put',
      data:params
    })
  },
  // 边坡设备列表
  sensorList: (params) => {
    return request({
      url: 'data/mp/sensorList',
      method: 'get',
      params
    })
  },
  // 温度设备列表
  sensorListwen: (params) => {
    return request({
      url: 'data/sz/sensorList/wen',
      method: 'get',
      params
    })
  },
  // 风速设备列表
  sensorListfeng: (params) => {
    return request({
      url: 'data/sz/sensorList/feng',
      method: 'get',
      params
    })
  },
  // 降雨设备列表
  sensorListrg: (params) => {
    return request({
      url: '/data/rg/sensorList',
      method: 'get',
      params
    })
  },
  //边坡设置报警级别
  drybeachequipinforlevel: (params) => {
    return request({
      url: 'tab/drybeachequipinfor/level',
      method: 'put',
      data:params
    })
  },
 
}
