import request from '@/utils/request'

export default {
  // 监测点数据类型
  monitoringPointDataTypes: () => {
    return [{
      key: 1, value: '开关量'
    }, {
      key: 2, value: '模拟量'
    }]
  },
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/iot-normal-machine/environment/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getDataList: (pageParam) => {
    return request({
      url: 'api/video-mine',
      method: 'get',
      params: pageParam
    })
  },

  // 新增
  add: (iotNormalMachine) => {
    return request({
      url: 'api/video-mine',
      method: 'post',
      data: iotNormalMachine
    })
  },
  // 修改
  set: (iotNormalMachine) => {
    return request({
      url: 'api/video-mine',
      method: 'put',
      data: iotNormalMachine
    })
  },
  // 删除
  deleteById: (ids) => {
    return request({
      url: 'api/video-mine',
      method: 'delete',
      data: ids
    })
  },
  // 根据企业查询所属矿山（含停产）enterpriseId
  getAllMineByEnterpriseId: (mineSearchParam) => {
    return request({
      url: 'api/mine/all-mine/list',
      method: 'get',
      params: mineSearchParam
    })
  }
  

}
