import Vue from 'vue'
import Router from 'vue-router'
import Layout from '../layout/index'

Vue.use(Router)

export const constantRouterMap = [
  { path: '/enterpriseApply',
    meta: { title: '企业注册申请', noCache: true },
    component: (resolve) => require(['@/views/enterpriseApply'], resolve),
    hidden: true
  },
  { path: '/login',
    meta: { title: '登录', noCache: true },
    component: (resolve) => require(['@/views/login'], resolve),
    hidden: true
  },
  { path: '/login4Index',
    meta: { title: '中间页', noCache: true },
    component: (resolve) => require(['@/views/home4Index'], resolve),
    hidden: true
  },
  {
    path: '/print',
    meta: { title: '打印', noCache: true },
    component: (resolve) => require(['@/views/print'], resolve),
    hidden: true
  },
  {
    path: '/404',
    component: (resolve) => require(['@/views/features/404'], resolve),
    hidden: true
  },
  {
    path: '/401',
    component: (resolve) => require(['@/views/features/401'], resolve),
    hidden: true
  },
  {
    path: '/redirect',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '/redirect/:path*',
        component: (resolve) => require(['@/views/features/redirect'], resolve)
      }
    ]
  },
  {
    path: '/',
    component: Layout,
    redirect: '/dashboard',
    hidden: true,
    children: [
      {
        path: 'dashboard',
        component: (resolve) => require(['@/views/home'], resolve),
        name: 'Dashboard',
        meta: { title: '首页', affix: true, noCache: true }
      }
    ]
  },
  {
    path: '/home4Login',
    meta: { title: '首页', noCache: true },
    component: (resolve) => require(['@/views/home4Login'], resolve),
    hidden: true
  },
  {
    path: '/home4Mine',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '',
        component: (resolve) => require(['@/views/home4Mine'], resolve),
        name: 'Home4Mine',
        meta: { title: '矿山首页', noCache: true }
      }
    ]
  },
  {
    path: '/home4Center',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '',
        component: (resolve) => require(['@/views/home4Center'], resolve),
        name: 'Home4Center',
        meta: { title: '中和地信应急平台', noCache: true }
      }
    ]
  },
  {
    path: '/home4Enterprise',
    component: Layout,
    hidden: true,
    children: [
      {
        path: '',
        component: (resolve) => require(['@/views/home4Enterprise'], resolve),
        name: 'Home4Enterprise',
        meta: { title: '企业首页', noCache: true }
      }
    ]
  },
  {
    path: '/user',
    component: Layout,
    hidden: true,
    redirect: 'noredirect',
    children: [
      {
        path: 'center',
        component: (resolve) => require(['@/views/system/user/center'], resolve),
        name: '个人中心',
        meta: { title: '个人中心' }
      }
    ]
  }
]

export default new Router({
  // mode: 'hash',
  // mode: 'history',
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRouterMap
})
