import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/dangerous-work/id',
      method: 'get',
      params: { id }
    })
  },
  // UUID查询
  getByWorkUuid: (uuid) => {
    return request({
      url: 'api/dangerous-work/work-uuid',
      method: 'get',
      params: { uuid }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/dangerous-work/page',
      method: 'get',
      params: pageParam
    })
  },
  // 新增
  add: (dangerousWork) => {
    return request({
      url: 'api/dangerous-work/add',
      method: 'post',
      data: dangerousWork
    })
  },
  // 删除
  del: (dangerousWork) => {
    return request({
      url: 'api/dangerous-work/del',
      method: 'post',
      data: {
        id: dangerousWork.id
      }
    })
  },
  // 变更（不是修改）
  update: (dangerousWork) => {
    dangerousWork.enterpriseId = null
    dangerousWork.mineType = null
    dangerousWork.mineId = null
    dangerousWork.createDatetime = null
    dangerousWork.createBy = null
    dangerousWork.workUuid = null
    dangerousWork.hasEnable = null
    dangerousWork.auditState = null
    dangerousWork.auditDatetime = null
    dangerousWork.auditBy = null
    dangerousWork.workStateChangeDatetime = null
    dangerousWork.workStateChangeBy = null
    dangerousWork.workState = null
    dangerousWork.complaint = null
    dangerousWork.complaintFilesPath = null
    dangerousWork.complaintDatetime = null
    dangerousWork.complaintBy = null
    return request({
      url: 'api/dangerous-work/update',
      method: 'post',
      data: dangerousWork
    })
  },
  // 审核
  audit: (dangerousWork) => {
    return request({
      url: 'api/dangerous-work/audit',
      method: 'post',
      data: dangerousWork
    })
  },
  // 审核通过全部
  auditAll: (dangerousWork) => {
    return request({
      url: 'api/dangerous-work/audit-all',
      method: 'post',
      data: dangerousWork
    })
  },
  // 修改状态
  setWorkState: (dangerousWork) => {
    return request({
      url: 'api/dangerous-work/set-work-state',
      method: 'post',
      data: dangerousWork
    })
  },
  // 申诉
  complaint: (dangerousWork) => {
    return request({
      url: 'api/dangerous-work/complaint',
      method: 'post',
      data: dangerousWork
    })
  }
}
