import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/hc-monitor/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/hc-monitor/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/hc-monitor/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (staff) => {
    return request({
      url: 'api/hc-monitor/add',
      method: 'post',
      data: staff
    })
  },
  // 删除
  del: (staff) => {
    return request({
      url: 'api/hc-monitor/del',
      method: 'post',
      data: {
        id: staff.id
      }
    })
  }
}
