import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/emergency-drill/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/emergency-drill/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/emergency-drill/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (emergencyDrill) => {
    return request({
      url: 'api/emergency-drill/add',
      method: 'post',
      data: emergencyDrill
    })
  },
  // 修改
  set: (emergencyDrill) => {
    emergencyDrill.enterpriseId = null
    emergencyDrill.mineType = null
    emergencyDrill.mineId = null
    emergencyDrill.createDatetime = null
    emergencyDrill.createBy = null
    emergencyDrill.updateDatetime = null
    emergencyDrill.updateBy = null
    return request({
      url: 'api/emergency-drill/set',
      method: 'post',
      data: emergencyDrill
    })
  },
  // 删除
  del: (emergencyDrill) => {
    return request({
      url: 'api/emergency-drill/del',
      method: 'post',
      data: {
        id: emergencyDrill.id
      }
    })
  }
}
