import request from '@/utils/request'

export default {
  // 矿山类型
  type: () => {
    return [{
      key: 1, value: '地下矿山'
    }, {
      key: 2, value: '露天矿山'
    }, {
      key: 3, value: '尾矿库'
    }]
  },
  // 运行状况
  runStates: () => {
    return [{
      key: 1, value: '基建'
    }, {
      key: 2, value: '停建'
    }, {
      key: 3, value: '生产'
    }, {
      key: 4, value: '停产'
    }]
  },
  // 新增地下矿山
  addUnderground: (mine) => {
    return request({
      url: 'api/mine/underground',
      method: 'post',
      data: mine
    })
  },
  // 新增露天矿山
  addOpencast: (mine) => {
    return request({
      url: 'api/mine/opencast',
      method: 'post',
      data: mine
    })
  },
  // 新增尾矿库
  addTailings: (mine) => {
    return request({
      url: 'api/mine/tailings',
      method: 'post',
      data: mine
    })
  },
  // 修改地下矿山
  setUnderground: (mine) => {
    mine.hasEnable = null
    // mine.enterpriseId = null
    mine.createDatetime = null
    mine.createBy = null
    mine.updateDatetime = null
    mine.updateBy = null
    return request({
      url: 'api/mine/underground/set',
      method: 'post',
      data: mine
    })
  },
  // 修改露天矿山
  setOpencast: (mine) => {
    mine.hasEnable = null
    // mine.enterpriseId = null
    mine.createDatetime = null
    mine.createBy = null
    mine.updateDatetime = null
    mine.updateBy = null
    return request({
      url: 'api/mine/opencast/set',
      method: 'post',
      data: mine
    })
  },
  // 修改尾矿库
  setTailings: (mine) => {
    mine.hasEnable = null
    // mine.enterpriseId = null
    mine.createDatetime = null
    mine.createBy = null
    mine.updateDatetime = null
    mine.updateBy = null
    return request({
      url: 'api/mine/tailings/set',
      method: 'post',
      data: mine
    })
  },
  // ID查询地下矿山
  getUndergroundById: (id) => {
    return request({
      url: 'api/mine/underground/id',
      method: 'get',
      params: { id }
    })
  },
  // ID查询露天矿山
  getOpencastById: (id) => {
    return request({
      url: 'api/mine/opencast/id',
      method: 'get',
      params: { id }
    })
  },
  // ID查询尾矿库
  getTailingsById: (id) => {
    return request({
      url: 'api/mine/tailings/id',
      method: 'get',
      params: { id }
    })
  },
  // 分页查询地下矿山
  getUndergroundPage: (undergroundSearchParam) => {
    return request({
      url: 'api/mine/underground/page',
      method: 'get',
      params: undergroundSearchParam
    })
  },
  // 导出地下矿山
  exportUnderground: (undergroundSearchParam) => {
    return request({
      url: 'api/mine/underground/export',
      method: 'get',
      params: undergroundSearchParam,
      responseType: 'blob'
    })
  },
  // 分页查询露天矿山
  getOpencastPage: (opencastSearchParam) => {
    return request({
      url: 'api/mine/opencast/page',
      method: 'get',
      params: opencastSearchParam
    })
  },
  // 导出露天矿山
  exportOpencast: (opencastSearchParam) => {
    return request({
      url: 'api/mine/opencast/export',
      method: 'get',
      params: opencastSearchParam,
      responseType: 'blob'
    })
  },
  // 分页查询尾矿库
  getTailingsPage: (tailingsSearchParam) => {
    return request({
      url: 'api/mine/tailings/page',
      method: 'get',
      params: tailingsSearchParam
    })
  },
  // 导出尾矿库
  exportTailings: (tailingsSearchParam) => {
    return request({
      url: 'api/mine/tailings/export',
      method: 'get',
      params: tailingsSearchParam,
      responseType: 'blob'
    })
  },
  // 查询全部运行中矿山
  getEnableMine: (mineSearchParam) => {
    if (!mineSearchParam) {
      mineSearchParam = {}
    }
    mineSearchParam.hasEnable = true
    return request({
      url: 'api/mine/all',
      method: 'get',
      params: mineSearchParam
    })
  },
  // 查询全部矿山（含停产）
  getAllMine: (mineSearchParam) => {
    return request({
      url: 'api/mine/all',
      method: 'get',
      params: mineSearchParam
    })
  },
  // 根据企业查询所属矿山（含停产）enterpriseId
  getAllMineByEnterpriseId: (mineSearchParam) => {
    return request({
      url: 'api/mine/underground/list',
      method: 'get',
      params: mineSearchParam
    })
  }

}
