import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/staff-job/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/staff-job/page',
      method: 'get',
      params: pageParam
    })
  },
  // 新增
  add: (staffJob) => {
    return request({
      url: 'api/staff-job/add',
      method: 'post',
      data: staffJob
    })
  },
  // 修改
  set: (staffJob) => {
    staffJob.enterpriseId = null
    staffJob.mineType = null
    staffJob.mineId = null
    staffJob.createDatetime = null
    staffJob.createBy = null
    staffJob.updateDatetime = null
    staffJob.updateBy = null
    return request({
      url: 'api/staff-job/set',
      method: 'post',
      data: staffJob
    })
  },
  // 删除
  del: (staffJob) => {
    return request({
      url: 'api/staff-job/del',
      method: 'post',
      data: {
        id: staffJob.id
      }
    })
  }
}
