import axios from 'axios'
import { Notification } from 'element-ui'

export default {
  send: (url, options, callback) => {
    return axios.request(url, options).then(res => {
      if (res.status && res.status >= 200 && res.status - 200 < 100) {
        if (callback) {
          callback(res.data)
          return
        }
      }
      console.error(res)
      Notification.error({
        title: 'WVP网络请求错误',
        duration: 2000
      })
    }).catch(err => {
      console.error(err)
      Notification.error({
        title: 'WVP网络请求失败',
        duration: 2000
      })
    })
  },
}
