import request from '@/utils/request'

export default {
  // 测点类型s
  monitoringTypes: () => {
    return [
      { code: '1001', name: '一氧化碳' },
      { code: '1002', name: '氮氧化物' },
      { code: '1003', name: '二氧化硫' },
      { code: '1004', name: '硫化氢' },
      { code: '1005', name: '氨' },
      { code: '1006', name: '二氧化碳' },
      { code: '1007', name: '氧气' },
      { code: '1008', name: '温度' },
      { code: '1009', name: '湿度' },
      { code: '1010', name: '烟雾' },
      { code: '1011', name: '湿球温度' },
      { code: '1012', name: '大气压' },
      { code: '1101', name: '箕斗位置' },
      { code: '1102', name: '罐笼位置' },
      { code: '1103', name: '人车位置' },
      { code: '1104', name: '矿车位置' },
      { code: '1105', name: '提升速度' },
      { code: '1106', name: '轴承温度' },
      { code: '1108', name: '钢丝绳直径' },
      { code: '1109', name: '钢丝绳断丝' },
      { code: '1201', name: '风速' },
      { code: '1202', name: '风压' },
      { code: '1301', name: '电流' },
      { code: '1302', name: '电压' },
      { code: '1303', name: '功率' },
      { code: '1401', name: '液位' },
      { code: '1402', name: '压力' },
      { code: '1403', name: '流量' },
      { code: '1501', name: '微震(事件)' },
      { code: '1502', name: '应力' },
      { code: '1503', name: '位移' },
      { code: '1601', name: '降雨量' },
      { code: '1602', name: '地表沉降' },
      { code: '1701', name: '开停状态' }
    ]
  },
  // 获取测点类型
  getMonitoringTypeByCode(code) {
    if (code && code.length >= 14) {
      const letCode = code.substring(10, 14)
      const pointTypes = this.monitoringTypes()
      for (const pIndex in pointTypes) {
        if (letCode === pointTypes[pIndex].code) {
          return pointTypes[pIndex]
        }
      }
    }
    return null
  },
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/iot-normal-machine/ground-pressure/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/iot-normal-machine/ground-pressure/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/iot-normal-machine/ground-pressure/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (iotNormalMachine) => {
    return request({
      url: 'api/iot-normal-machine/ground-pressure/add',
      method: 'post',
      data: iotNormalMachine
    })
  },
  // 修改
  set: (iotNormalMachine) => {
    iotNormalMachine.enterpriseId = null
    iotNormalMachine.mineType = null
    iotNormalMachine.mineId = null
    iotNormalMachine.createDatetime = null
    iotNormalMachine.createBy = null
    iotNormalMachine.updateDatetime = null
    iotNormalMachine.updateBy = null
    iotNormalMachine.hasEnable = null
    iotNormalMachine.code = null
    iotNormalMachine.useType = null
    return request({
      url: 'api/iot-normal-machine/ground-pressure/set',
      method: 'post',
      data: iotNormalMachine
    })
  },
  // 删除
  del: (iotNormalMachine) => {
    return request({
      url: 'api/iot-normal-machine/ground-pressure/del',
      method: 'post',
      data: {
        id: iotNormalMachine.id
      }
    })
  }
}
