import request from '@/utils/request'

export default {
  // 审核状态
  auditStates: () => {
    return [{
      key: 1, value: '未审核'
    }, {
      key: 2, value: '审核通过'
    }, {
      key: 3, value: '审核不通过'
    }]
  },
  // 申请
  apply: (enterprise) => {
    return request({
      url: 'api/enterprise/apply',
      method: 'post',
      data: enterprise
    })
  },
  // 分页查询
  getPage: (enterpriseSearchParam) => {
    return request({
      url: 'api/enterprise/page',
      method: 'get',
      params: enterpriseSearchParam
    })
  },
  // 导出
  export: (enterpriseSearchParam) => {
    return request({
      url: 'api/enterprise/export',
      method: 'get',
      params: enterpriseSearchParam,
      responseType: 'blob'
    })
  },
  // 审核
  audit: (enterprise) => {
    return request({
      url: 'api/enterprise/audit',
      method: 'post',
      data: enterprise
    })
  },
  // 审核全部
  auditAll: (enterprise) => {
    return request({
      url: 'api/enterprise/audit-all',
      method: 'post',
      data: enterprise
    })
  },
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/enterprise/id',
      method: 'get',
      params: { id }
    })
  },
  // 查询我的企业
  getMy: () => {
    return request({
      url: 'api/enterprise/my',
      method: 'get'
    })
  },
  // 修改我的企业
  setMy: (enterprise) => {
    enterprise = JSON.parse(JSON.stringify(enterprise))
    enterprise.name = null
    enterprise.createDatetime = null
    enterprise.createBy = null
    enterprise.updateDatetime = null
    enterprise.updateBy = null
    enterprise.hasEnable = null
    enterprise.applyDatetime = null
    enterprise.auditState = null
    enterprise.auditDatetime = null
    enterprise.auditBy = null
    return request({
      url: 'api/enterprise/set-my',
      method: 'post',
      data: enterprise
    })
  }
}
