import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/notice/id',
      method: 'get',
      params: { id }
    })
  },
  // ID查询回执情况
  getResponseByNoticeId: (id) => {
    return request({
      url: 'api/notice/response/by-notice-id',
      method: 'get',
      params: { id }
    })
  },
  // 中心page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/notice/page',
      method: 'get',
      params: pageParam
    })
  },
  // 查询未读数量：开启查询总数即可
  // 查询回执情况
  // 矿山端（企业端）page查询（本质是根据答复情况查询）
  getResponsePage: (pageParam) => {
    return request({
      url: 'api/notice/response/page',
      method: 'get',
      params: pageParam
    })
  },
  // 新增
  add: (notice) => {
    return request({
      url: 'api/notice/add',
      method: 'post',
      data: notice
    })
  },
  // 标记已读（查询权限）
  read: (responseId) => {
    return request({
      url: 'api/notice/read',
      method: 'post',
      data: {
        id: responseId
      }
    })
  },
  // 删除
  del: (notice) => {
    return request({
      url: 'api/notice/del',
      method: 'post',
      data: {
        id: notice.id
      }
    })
  }
}
