import request from '@/utils/request'

export default {
  // 全部分组
  getAllDictionaryGroup: () => {
    return request({
      url: 'api/dictionary/group/all',
      method: 'get'
    })
  },
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/dictionary/id',
      method: 'get',
      params: { id }
    })
  },
  // 查询列表
  getList: (dictionarySearchParam) => {
    return request({
      url: 'api/dictionary/list',
      method: 'get',
      params: dictionarySearchParam
    })
  },
  // 新增
  add: (dictionary) => {
    return request({
      url: 'api/dictionary/add',
      method: 'post',
      data: dictionary
    })
  },
  // 修改
  set: (dictionary) => {
    return request({
      url: 'api/dictionary/set',
      method: 'post',
      data: dictionary
    })
  },
  // 删除
  del: (dictionary) => {
    return request({
      url: 'api/dictionary/del',
      method: 'post',
      data: dictionary
    })
  }
}
