import request from '@/utils/request'

export default {
  // ID查询
  getById: (id) => {
    return request({
      url: 'api/iot-person-base-station/id',
      method: 'get',
      params: { id }
    })
  },
  // page查询
  getPage: (pageParam) => {
    return request({
      url: 'api/iot-person-base-station/page',
      method: 'get',
      params: pageParam
    })
  },
  // 导出
  export: (pageParam) => {
    return request({
      url: 'api/iot-person-base-station/export',
      method: 'get',
      params: pageParam,
      responseType: 'blob'
    })
  },
  // 新增
  add: (iotPersonBaseStation) => {
    return request({
      url: 'api/iot-person-base-station/add',
      method: 'post',
      data: iotPersonBaseStation
    })
  },
  // 修改
  set: (iotPersonBaseStation) => {
    iotPersonBaseStation = JSON.parse(JSON.stringify(iotPersonBaseStation))

    iotPersonBaseStation.enterpriseId = null
    iotPersonBaseStation.mineType = null
    iotPersonBaseStation.mineId = null
    iotPersonBaseStation.createDatetime = null
    iotPersonBaseStation.createBy = null
    iotPersonBaseStation.updateDatetime = null
    iotPersonBaseStation.updateBy = null

    iotPersonBaseStation.code = null
    return request({
      url: 'api/iot-person-base-station/set',
      method: 'post',
      data: iotPersonBaseStation
    })
  },
  // 删除
  del: (iotPersonBaseStation) => {
    return request({
      url: 'api/iot-person-base-station/del',
      method: 'post',
      data: {
        id: iotPersonBaseStation.id
      }
    })
  }
}
