import request from '@/utils/request'

export default {
  // 绑定我的
  addMy: (iotMachine) => {
    return request({
      url: 'api/iot-machine/add/my',
      method: 'post',
      data: iotMachine
    })
  },
  // 移除我的
  removeMy: () => {
    return request({
      url: 'api/iot-machine/remove-all/my',
      method: 'post'
    })
  },
  // 查询我的
  getDataList:(params) => {
    return request({
      url: 'data/mp/history',
      method: 'get',
      params
    })
  },
  // 查询风速、温度
    getDataList4windSpeed: (params) => {
    return request({
      url: 'data/sz/history',
      method: 'get',
      params
    })
  },
    // 查询降雨量
    getDataList4waterPrecipitation: (params) => {
      return request({
        url: 'data/rg/history',
        method: 'get',
        params
      })
    }
}
