
import axios from 'axios'
import { config as appConfig } from '../config.js'
import { Message } from 'element-ui'
import bus from "@/axios/bus.js";
// axios 配置
axios.defaults.baseURL = appConfig.BASE_URL;
axios.defaults.timeout = 500000;
axios.defaults.headers = {
    "Content-Type": "application/x-www-form-urlencoded;charset=UTF-8"
}
// http request 请求拦截器，有token值则配置上token值
axios.interceptors.request.use(
    config => {
        var token = localStorage.getItem(appConfig.TOKEN_KEY);
        if (localStorage.getItem(appConfig.USER_KEY)) {
            let ticket = JSON.parse(localStorage.getItem(appConfig.USER_KEY)).ticket;
            config.headers.ticket = ticket == null ? '' : ticket;
        }
        config.headers.token = token == null ? '' : token;

        return config;
    },
    err => {
        return Promise.reject(err);
    }
);

// http response 服务器响应拦截器，这里拦截401错误，并重新跳入登页重新获取token
axios.interceptors.response.use(
    response => {
        return response;
    },
    error => {
        if (error.response) {
            console.log(error.response.status)
            switch (error.response.status) {
                case 403:
                    Message({
                        message: "登录凭证失效，请重新登录",
                        type: 'warning'
                    });
                    window.location.href = '#/login';
                    error.message = "登录凭证失效，请重新登录";
                    bus.$emit("todoDetailWebsocket");
                    break
                case 401:
                    Message({
                        message: '未授权，请重新登录',
                        type: 'warning'
                    });
                    error.message = '未授权，请重新登录';
                    break
                // localStorage.removeItem(appConfig.TOKEN_KEY)
                // localStorage.removeItem(appConfig.USER_KEY)
                // router.replace({
                //     path: '/login',
                //     // query: {redirect: router.currentRoute.fullPath}//登录成功后跳入浏览的当前页面
                // })
                case 400:
                    error.message = '错误请求'
                case 404:
                    error.message = '请求错误,未找到该资源'
                    break
                case 405:
                    error.message = '请求方法未允许'
                    break
                case 408:
                    error.message = '请求超时'
                    break
                case 500:
                    Message({
                        message: '内部服务器错误，请联系管理员',
                        type: 'warning'
                    });
                    break
                case 501:
                    error.message = '网络未实现'
                    break
                case 502:
                    error.message = '网络错误'
                    break
                case 503:
                    error.message = '服务不可用'
                    break
                case 504:
                    error.message = '网络超时'
                    break
                case 505:
                    error.message = 'http版本不支持该请求'
                    break
                default:
                    error.message = `连接错误${error.response.status}`
                // router.replace({
                //     path: '/',
                //     query: {redirect: router.currentRoute.fullPath}//登录成功后跳入浏览的当前页面
                // })
            }
            // console.log(error.response);
        } else {
            Message({
                message: "请求资源失败，请联系管理员",
                type: 'warning'
            });
        }
        return Promise.reject(error)
    }
);

export default axios;
