import axios from '../axios/axiosConfig';
import { config as appConfig } from '../config.js';
import * as api from '../axios/api.js';
import qs from 'qs';
import whiteList from '../axios/whiteList';


if (!appConfig.BASE_URL) {
    appConfig.BASE_URL = appConfig.REAL_URL;
} else if (!appConfig.REAL_URL) {
    appConfig.REAL_URL = appConfig.BASE_URL;
}
//获取url
function getUrl(url) {
    let urlPre = url.split('?')[0];
    let flag = false;
    $.each(api, (key, val) => {
        if (urlPre == val) {
            $.each(whiteList, (_, wl) => {
                if (wl.key == key && wl.isMock) {
                    flag = true;
                    return false;
                }
            });
        }
    });
    if (!flag) {
        url = appConfig.REAL_URL + url;
    }
// console.log(url);
    return url;
}

/**
 * 封装get方法
 * @param url
 * @param data
 * @returns {Promise}
 */
export function httpGet(url, params = {}) {
    url = getUrl(url);
    // log(url);
    return new Promise((resolve, reject) => {
        //这几个几url始终使用mokc数据
        if (url.indexOf('alarm/bigScreen/alertComponent') > -1) {
            resolve(alertComponen());
        } else if (url.indexOf('alarm/bigScreen/securityComponent') > -1) {
            resolve(securityComponent());
        } else {
            axios
                .get(url, {
                    params: params
                })
                .then(response => {
                    resolve(response.data);
                })
                .catch(err => {
                    reject(err);
                });
        }
    });
}

/**
 * 封装post请求
 * @param url
 * @param data
 * @returns {Promise}
 */
export function httpPost(url, data = {}) {
    url = getUrl(url);
    
    return new Promise((resolve, reject) => {
        // console.log(url);
        axios.post(url, qs.stringify(data)).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}

/**
 * 封装patch请求
 * @param url
 * @param data
 * @returns {Promise}
 */
export function patch(url, data = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios.patch(url, data).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}

/**
 * 封装put请求
 * @param url
 * @param data
 * @returns {Promise}
 */
export function put(url, data = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios.put(url, qs.stringify(data)).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}
/**
 * 封装put请求 参数放在body
 * @param url
 * @param data
 * @returns {Promise}
 */
export function putForJson(url, data = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios({
            method: 'put',
            url: url,
            data: data,
            headers: { 'Content-Type': 'application/json;charset=UTF-8' }
        }).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}

/**
 * 封装del请求
 * @param url
 * @param data
 * @returns {Promise}
 */
export function httpDel(url, data = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios.delete(url, { params: data }).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}

export function httpPostForJson(url, data = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios({
            method: 'post',
            url: url,
            data: data,
            headers: { 'Content-Type': 'application/json;charset=UTF-8' }
        }).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}
export function httpGetFile(url, params = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios({
            method: 'get',
            url: url,
            params: params,
            responseType: 'blob'
        }).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}

export function httpGetExport(url, params = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios
            .get(url, {
                params: params,
                responseType: 'arraybuffer'
            })
            .then(response => {
                resolve(response.data);
            })
            .catch(err => {
                reject(err);
            });
    });
}

export function httpPostExport(url, params = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios
            .post(url, {
                params: qs.stringify(params),
                responseType: 'arraybuffer'
            })
            .then(response => {
                resolve(response.data);
            })
            .catch(err => {
                reject(err);
            });
    });
}

export function fileDownload(data, fileName) {
    let blob = new Blob([data], {
        type: 'application/octet-stream;charset=utf-8'
    });
    let filename = fileName || 'filename';
    if (typeof window.navigator.msSaveBlob !== 'undefined') {
        window.navigator.msSaveBlob(blob, filename);
    } else {
        var blobURL = window.URL.createObjectURL(blob);
        var tempLink = document.createElement('a');
        tempLink.style.display = 'none';
        tempLink.href = blobURL;
        tempLink.setAttribute('download', filename);
        if (typeof tempLink.download === 'undefined') {
            tempLink.setAttribute('target', '_blank');
        }
        document.body.appendChild(tempLink);
        tempLink.click();
        document.body.removeChild(tempLink);
        window.URL.revokeObjectURL(blobURL);
    }
}

export function httpUpload(url, data = {}) {
    url = getUrl(url);
    return new Promise((resolve, reject) => {
        axios({
            method: 'post',
            url: url,
            data: data,
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
        }).then(
            response => {
                resolve(response.data);
            },
            err => {
                reject(err);
            }
        );
    });
}
// // 下载方法
// export function fileDownload (data, fileName) {
//   let blob = new Blob([data], {
//       type: "application/octet-stream"
//   });
//   let filename = fileName || "filename";
//   if (typeof window.navigator.msSaveBlob !== "undefined") {
//       window.navigator.msSaveBlob(blob, filename);
//   } else {
//       var blobURL = window.URL.createObjectURL(blob);
//       var tempLink = document.createElement("a");
//       tempLink.style.display = "none";
//       tempLink.href = blobURL;
//       tempLink.setAttribute("download", filename);
//       if (typeof tempLink.download === "undefined") {
//           tempLink.setAttribute("target", "_blank");
//       }
//       document.body.appendChild(tempLink);
//       tempLink.click();
//       document.body.removeChild(tempLink);
//       window.URL.revokeObjectURL(blobURL);
//   }
// }
