let Path = require('path')
let glob = require('glob')

const apiFiles = glob.sync(Path.resolve(__dirname, './') + '/**/*.js', {
  nodir: true
})

let prefix = "hlkj/"
let data = {}

for(let i = 0; i < apiFiles.length; i++)
{
    if(apiFiles[i].indexOf("index") < 0)
    {
        let api = require(apiFiles[i])
        api.url = prefix + api.url;

        for(let param1 in api.data)
        {
            data[api.url.replace(/\//g, '_')+param1] = api.data[param1]
        }
    }
}

module.exports = function () {
  return data
}