const Mock = require("mockjs");
const moment = require("moment");
module.exports = {
    url:"workOrder/",
    data:{
        getInfoById:getInfoById(),
        findCustomerInfo:findCustomerInfo(),
        getGovServiceByParam:getgovermentList(),
        getOrderInfoById:getOrderInfoById(),
        getOraIsNotFour:getOraIsNotFour(),
        findWaitingls:findWaiting(),
        selectNodeListBycustId:Mock.mock({returnBoolean:true,"returnObject": [1,2,3,4]}),
        selectHisrecord:selectHisrecord()
    }
};

function getInfoById()
{
    return {returnObject:{"workOrder":{"faultAddress":"fdsfdsaf","rodCode":"","propertyRight":"","lineName":"","newFault":"","vehicle":"","customerComments":"","reference":"","eliminationTime":"","emergencyLevel":"02","appointmentTime":"","causeFailure":"","arrivalTime":"","customerId":"3000000000","siteClass":"02","id":"2000000666","preliminary":"","expatriatePersonnel":"","rushRepairRecord":"","secondClass":"","receivingPoint":"","faultScene":"02","faultAssignment":"","thirdClass":"","voltageGrade":"","appointmentReasons":"","firstClass":"02","repairTime":"","powerPoint":"","estimatedRepairTime":"","contractorOpinion":""},"requestOrder":null,"customerInfo":{"handler":"","businessType":"02","subordinate":"gddw_010201","customerCode":"222","orderStatus":"1","acceptedContents":"【一户无电】低压居民客户报修一户无电，经指导客户检查，无法判断设备故障及其资产归属，请现场查处。（ 客户无法提供户号，只能提供地址）。","auditorPerson":"","flowInstanceId":"2000000222","customerType":"khlx_02","creatTime":"2019-02-24 00:33:05","businessTypeName":"故障","powerSupplyUnit":"010101","creatUser":"4941632","contactAddress":"山东省德州市德城区将军路刘集小区13号楼1单元502","id":"3000000000","returnVisitMode":"2","secondDept":"218","nodeStatus":"2","customerName":"刘女士","sendTime":"2019-02-24 00:33:05","filing":"","branchOffice":"gddw_0102","phone":"18678366251","sendPer":"4941632","dataSource":"1","contacts":"刘女士","disPatchMen":""}}};
}

function findCustomerInfo()
{
    //{"id":"","customerCode":"","businessType":"","creatUser":"","contactAddress":"","phone":"","acceptedContents":"","customerName":""}
    return Mock.mock({totalResult:'@integer(10,100)',"returnObject|1-10":[{"handler":"","subordinate":"gddw_010201","customerCode":"222","orderStatus":"1","acceptedContents":"【一户无电】低压居民客户报修一户无电，经指导客户检查，无法判断设备故障及其资产归属，请现场查处。（ 客户无法提供户号，只能提供地址）。","auditorPerson":"","flowInstanceId":"2000000222","customerType":"khlx_02","creatTime":"2019-02-24 00:33:05","businessTypeName":"故障","powerSupplyUnit":"010101","creatUser":"4941632","contactAddress":"山东省德州市德城区将军路刘集小区13号楼1单元502","id":"3000000000","returnVisitMode":"2","secondDept":"218","nodeStatus":"2","customerName":"@cname","sendTime":"2019-02-24 00:33:05","filing":"","branchOffice":"gddw_0102","phone":"18678366251","sendPer":"4941632","dataSource":"1","contacts":"@cname","disPatchMen":""}]});
}

function getgovermentList()
{
    return Mock.mock({totalResult:'@integer(10,100)',returnBoolean:true,total:"@integer(40,100)","returnObject|5-20":[{
            'orderNo|+1': 1, //工单编号
                    sendTime: '@datetime', //发送时间
                    problemDesc: '@string', //问题描述
                    adminOp: '@string', //转办意见
                    timeLimit: '@datetime', //  办理时限
                    contacts: '@cname', //联系人     
                    'contacNo|+1': 18764087555, //联系电话     
                    contactAdd: '@county(true)', //联系地址   
                    'emergencyLevel|1': ["一般","紧急"], //紧急程度
                    'issecret|1': ["是","否"], //保密     
                    'processFlow|1': ["派发","分派","处理","审核","归档"], //转办流程  
                    sender: '@cname', //发送人       
                    remark: '@string', //备注       
    }]});
}

function getOrderInfoById()
{
    return Mock.mock({returnBoolean:true,total:"@integer(40,100)","returnObject":{
        'orderNo': '@integer(40,100)', //工单编号
                sendTime: '@datetime', //发送时间
                problemDesc: '@string', //问题描述
                adminOp: '@string', //转办意见
                timeLimit: '@datetime', //  办理时限
                contacts: '@cname', //联系人     
                'contacNo|+1': 18764087555, //联系电话     
                contactAdd: '@county(true)', //联系地址   
                'emergencyLevel|1': ["一般","紧急"], //紧急程度
                'issecret|1': ["是","否"], //保密     
                'processFlow|1': ["派发","分派","处理","审核","归档"], //转办流程  
                sender: '@cname', //发送人       
                remark: '@string', //备注 
                "callType|1": ["咨询","建议","表扬"], //来电类别
                inputTime: '@datetime', //录入时间
                level: '', //问题分类 需要将五级分类组合
                levelone: 'AAA',
                leveltwo:'BBB',
                levelthree:'CCC',
                levelfour:'DDD',
                levelfive:'FFF',
                orderType: '', //工单类型
                'receChannel|1': ["短信","市长热线","微信"], //受理渠道
                orderStatus: '', //工单状态
                isreply: '', //是否回复
                replynote: '', //回复备注
                processType: '', //办理类型
                receivemo: '@integer(100000,20000)', //受理员编号
                issuer:'@cname',//签发人
                handSituation:'@string',//办理情况
                replyTime:'@datetime',//答复时间
                respondent:'@cname',//答复人
                'replyPhone|+5':18764087555,//答复电话
                replyDep:'',//答复部门
                'replyDepPhone|+5':18164087555,//答复部门电话
                replySituation:'@string',//答复来电人情况
                // blgj:'@string',//办理轨迹
                sendTime:'@datetime',//发送时间
    }});
}

function getOraIsNotFour()
{
    return {};
}

function findWaiting()
{
    return Mock.mock({returnBoolean:true,"returnObject|1-10":[
        {id:'@integer(40,100)',
        'dataSource|1':[1,2],
        'businessType|1':[1,2,3,4,5],
        'businessTypeName|1':["咨询","投诉","故障","表扬"],
        sender:"@cname",
        beginTime:'@datetime',
        procestate:'@string',
        descriptive:'@string(20,50)'
    }]});
}

function selectHisrecord()
{
    return Mock.mock({returnBoolean:true,"returnObject|1-10":[
        {
        'id':'@integer(40,100)',	
        'flowinstanceId':'@integer(40,100)',
        'sender':'@integer(40,100)',		
        'receiver':'@integer(40,100)',		
        'beginTime':'@datetime',		
        'endTime':'@datetime',		
        'proceState':'@string',	
        'descriptive':'@string',
        'senderName':'@cname',
        'receiverName':'@cname',	
        'nodeId|1':[1,2,3,4,5],
    }]});
   

}