import Vue from 'vue'
import VueRouter from 'vue-router'
//登陆页面
import login from '../views/login.vue'
//主页菜单
import homepage from "../views/homepage.vue";
//矿区监控
import mineMonitoring from '../views/mineMonitoring.vue'
//视频监控
import videoShow from '../views/videoSurveillance/videoShow.vue'
import videoSetting from '../views/videoSurveillance/videoSetting.vue'
//生产自动化系统
import AutomationHomepage from '../views/productionAutomation/AutomationHomepage.vue'
import AutomatedReport from '../views/productionAutomation/AutomatedReport.vue'
//人员定位系统
import PersonnelPositioningHomePage from '../views/personnelPositioning/homePage.vue'
import PersonnelPositioningNowData from '../views/personnelPositioning/nowData.vue'
import PersonnelPositioningTrajectory from '../views/personnelPositioning/trajectory.vue'
import PersonnelPositioningHistroyData from '../views/personnelPositioning/histroyData.vue'
import PersonnelPositioningAlarm from '../views/personnelPositioning/alarm.vue'
import PersonnelPositioningEnclosure from '../views/personnelPositioning/enclosure.vue'
import PersonnelPositioningRegister from '../views/personnelPositioning/register.vue'
//车辆定位系统
import carPositioningHomePage from '../views/carPositioning/homePage.vue'
import carPositioningNowData from '../views/carPositioning/nowData.vue'
import carPositioningTrajectory from '../views/carPositioning/trajectory.vue'
import carPositioningHistroyData from '../views/carPositioning/histroyData.vue'
import carPositioningAlarm from '../views/carPositioning/alarm.vue'
import carPositioningEnclosure from '../views/carPositioning/enclosure.vue'
import carPositioningRegister from '../views/carPositioning/register.vue'
import carPositioningEquipment from '../views/carPositioning/equipment.vue'
//边坡在线监测
import SlopeHomePage from '../views/slope/homePage.vue'
import SlopeHorizontal from '../views/slope/horizontal.vue'
import SlopeVertical from '../views/slope/vertical.vue'
import SlopeRainfall from '../views/slope/rainfall.vue'
import SlopeEarlyWarning from '../views/slope/earlyWarning.vue'
import SlopeHistory from '../views/slope/historyData.vue'
import SlopeAlarm from '../views/slope/alarm.vue'
//环境在线监测
import EnvironmentHomepage from '../views/environment/homepage.vue'
import EnvironmentNowData from '../views/environment/nowData.vue'
import EnvironmentHistory from '../views/environment/history.vue'
import EnvironmentAlarm from '../views/environment/alarm.vue'
//数字化储量管理
import reservesHomepage from '../views/reserves/homepage.vue'
import reservesList from '../views/reserves/list.vue'
//门禁系统
import AccessHomepage from '../views/AccessHomepage.vue'
//无人值守
import unman from '../views/unman.vue'
//系统管理
import personManagement from '../views/management/person.vue'
import carManagement from '../views/management/car.vue'

Vue.use(VueRouter)
//解决vue中路由冗余导航报错
const originalPush = VueRouter.prototype.push
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err)
}

const routes = [
  //登陆页面
  {
    path: '/login',
    name: 'login',
    component: login
  },
  //主页菜单
  {
    path: '/homepage',
    name: 'homepage',
    component: homepage,
    children: [
      //矿区监控
      {
        path: '/homepage/mineMonitoring',
        component: mineMonitoring
      },
      //视频监控
      {
        path: '/homepage/videoShow',
        component: videoShow
      },
      {
        path: '/homepage/videoSetting',
        component: videoSetting
      },
      //生产自动化系统
      {
        path: '/homepage/AutomationHomepage',
        component: AutomationHomepage
      },
      {
        path: '/homepage/AutomatedReport',
        component: AutomatedReport
      },
      //人员定位系统
      {
        path: '/homepage/PersonnelPositioningHomePage',
        component: PersonnelPositioningHomePage
      },
      {
        path: '/homepage/PersonnelPositioningNowData',
        component: PersonnelPositioningNowData
      },
      {
        path: '/homepage/PersonnelPositioningTrajectory',
        component: PersonnelPositioningTrajectory
      },
      {
        path: '/homepage/PersonnelPositioningHistroyData',
        component: PersonnelPositioningHistroyData
      },
      {
        path: '/homepage/PersonnelPositioningAlarm',
        component: PersonnelPositioningAlarm
      },
      {
        path: '/homepage/PersonnelPositioningEnclosure',
        component: PersonnelPositioningEnclosure
      },
      {
        path: '/homepage/PersonnelPositioningRegister',
        component: PersonnelPositioningRegister
      },
      //车辆定位系统
      {
        path: '/homepage/carPositioningHomePage',
        component: carPositioningHomePage
      },
      {
        path: '/homepage/carPositioningNowData',
        component: carPositioningNowData
      },
      {
        path: '/homepage/carPositioningTrajectory',
        component: carPositioningTrajectory
      },
      {
        path: '/homepage/carPositioningHistroyData',
        component: carPositioningHistroyData
      },
      {
        path: '/homepage/carPositioningAlarm',
        component: carPositioningAlarm
      },
      {
        path: '/homepage/carPositioningEnclosure',
        component: carPositioningEnclosure
      },
      {
        path: '/homepage/carPositioningRegister',
        component: carPositioningRegister
      },
      {
        path: '/homepage/carPositioningEquipment',
        component: carPositioningEquipment
      },
      //边坡在线监测
      {
        path: '/homepage/SlopeHomePage',
        component: SlopeHomePage
      },
      {
        path: '/homepage/SlopeHorizontal',
        component: SlopeHorizontal
      },
      {
        path: '/homepage/SlopeVertical',
        component: SlopeVertical
      },
      {
        path: '/homepage/SlopeRainfall',
        component: SlopeRainfall
      },
      {
        path: '/homepage/SlopeEarlyWarning',
        component: SlopeEarlyWarning
      },
      {
        path: '/homepage/SlopeHistory',
        component: SlopeHistory
      },
      {
        path: '/homepage/SlopeAlarm',
        component: SlopeAlarm
      },
      //环境在线监测
      {
        path: '/homepage/EnvironmentHomepage',
        component: EnvironmentHomepage
      },{
        path: '/homepage/EnvironmentNowData',
        component: EnvironmentNowData
      },{
        path: '/homepage/EnvironmentHistory',
        component: EnvironmentHistory
      },{
        path: '/homepage/EnvironmentAlarm',
        component: EnvironmentAlarm
      },
      //数字化储量管理
      {
        path: '/homepage/reservesHomepage',
        component: reservesHomepage
      },
      {
        path: '/homepage/reservesList',
        component: reservesList
      },
      //门禁系统
      {
        path: '/homepage/AccessHomepage',
        component: AccessHomepage
      },
      //无人值守
      {
        path: '/homepage/unman',
        component: unman
      },
      //系统管理
      {
        path: '/homepage/personManagement',
        component: personManagement
      },
      {
        path: '/homepage/carManagement',
        component: carManagement
      }
    ]
  },

  //  //懒加载
  // {
  //   path: '/about',
  //   name: 'About',
  //   // route level code-splitting
  //   // this generates a separate chunk (about.[hash].js) for this route
  //   // which is lazy-loaded when the route is visited.
  //   component: () => import(/* webpackChunkName: "about" */ '../views/About.vue')
  // },

  //路由重定向
  {
    name: 'default',
    path: '*',
    redirect: '/login'
  }
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router
