import request from '@/utils/request'

export function login(username, password, uuid) {
  return request({
    url: 'auth/login',
    method: 'post',
    data: {
      username,
      password,
      uuid
    }
  })
}

export function getInfo() {
  return request({
    url: 'auth/info',
    method: 'get'
  })
}

export function getCodeImg() {
  return request({
    url: process.env.VUE_APP_LOCAL_API2 + '/auth/code',
    method: 'get',
  })
}

export function logout() {
  return request({
    url: 'auth/logout',
    method: 'delete'
  })
}
