import Vue from "vue";
import Router from "vue-router";
import Layout from "../layout/index";
import HomeLayout from "../layout/home";

Vue.use(Router);

export const constantRouterMap = [
    {
        path: "/login",
        meta: { title: "登录", noCache: true },
        component: resolve => require(["@/views/login"], resolve),
        hidden: true
    },
	{
        path: "/register",
        meta: { title: "用户注册", noCache: true },
        component: resolve => require(["@/views/system/user/register"], resolve),
        hidden: true
    },
    {
        path: "/404",
		redirect: "/dashboard",
        component: resolve => require(["@/views/features/404"], resolve),
        hidden: true
    },
    {
        path: "/401",
        component: resolve => require(["@/views/features/401"], resolve),
        hidden: true
    },
    {
        path: "/redirect",
        component: Layout,
        hidden: true,
        children: [
            {
                path: "/redirect/:path*",
                component: resolve => require(["@/views/features/redirect"], resolve)
            }
        ]
    },
    {
        path: "/",
        component: HomeLayout,
        redirect: "/dashboard",
        children: [
            {
                path: "dashboard",
                component: (resolve) => require(['@/views/home_manage'], resolve),
                name: "Dashboard",
                meta: { title: "首页", icon: "index", affix: true, noCache: true },
                // component: () => {
                //     if (Vue.$state.state.user.user.username === "admin") {
                //         return import("@/views/home_manage");
                //     } else {
                //         return import("@/views/home_user");
                //     }
                // },
                hidden: true
            }
        ]
    },
    {
        path: "/user",
        component: Layout,
        hidden: true,
        redirect: "noredirect",
        children: [
            {
                path: "center",
                component: resolve => require(["@/views/system/user/center"], resolve),
                name: "个人中心",
                meta: { title: "个人中心" }
            }
        ]
    },
	
    {
        path: "/MLargeScreen/index",
        meta: { title: "数据大屏", noCache: true },
        component: () => {
            return import("@/views/MLargeScreen/index");
        },
        hidden: true
    }
];

export default new Router({
    mode: 'hash',
    //mode: "history",
    scrollBehavior: () => ({ y: 0 }),
    routes: constantRouterMap
});
