//entity示例中的图层通用js

//在图层级处理一些事物
import { Tools, HttpReq, CAMap} from '@/assets/js/common.js';
import 'mars3d/dist/mars3d.css'
import * as mars3d from 'mars3d'
import $ from 'jquery'

  export function initLayerManager(graphicLayer,index) {
    let rowName = index;
    //在layer上绑定监听事件
    graphicLayer.on(mars3d.EventType.click, function (event) {
      //console.log("监听layer，单击了矢量对象", event);
      // var mpt = mars3d.LatLngPoint.fromCartesian(event.cartesian);
      // console.log(mpt.toString(), "位置信息");
      // coordinates.push(mpt.toString().split(','));
      // console.log(coordinates);
    });
    // graphicLayer.on(mars3d.EventType.mouseOver, function(event) {
    //   console.log('监听layer，鼠标移入了矢量对象', event)
    // })
    // graphicLayer.on(mars3d.EventType.mouseOut, function(event) {
    //   console.log('监听layer，鼠标移出了矢量对象', event)
    // })
  
    //可在图层上绑定popup,对所有加到这个图层的矢量数据都生效
    bindLayerPopup(graphicLayer);
  
    $("#chkPopup").change(function () {
      let val = $(this).is(":checked");
  
      if (val) {
        bindLayerPopup(graphicLayer);
      } else {
        graphicLayer.unbindPopup();
      }
    });
  
    //可在图层上绑定tooltip,对所有加到这个图层的矢量数据都生效
    $("#chkTooltip").change(function () {
      let val = $(this).is(":checked");
  
      if (val) {
        graphicLayer.bindTooltip("我是layer上绑定的Tooltip");
      } else {
        graphicLayer.unbindTooltip();
      }
    });
  
    //可在图层绑定右键菜单,对所有加到这个图层的矢量数据都生效
    bindLayerContextMenu(graphicLayer,rowName);
    $("#chkContextMenu").change(function () {
      let val = $(this).is(":checked");
  
      if (val) {
        bindLayerContextMenu(graphicLayer,rowName);
      } else {
        graphicLayer.unbindContextMenu(true);
      }
    });
  
    $("#chkHasEdit").change(function () {
      let val = $(this).is(":checked");
  
      graphicLayer.hasEdit = val; //启用编辑
    });
  
    $("#chkShow").change(function () {
      let val = $(this).is(":checked");
  
      graphicLayer.show = val; //显示隐藏
    });
  
    $("#btnClear").click(function () {
      graphicLayer.clear();
    });
  
    $("#btnExpFile").click(function () {
      // window.layer.msg('该功能在开发完善中……')
      // return
  
      if (graphicLayer.length === 0) {
        window.layer.msg("当前没有标注任何数据，无需保存！");
        return;
      }
  
      let geojson = graphicLayer.toGeoJSON();
      haoutil.file.downloadFile("我的标注.json", JSON.stringify(geojson));
    });
  
    $("#btnImpFile").click(function () {
      $("#input_draw_file").click();
    });
  
    function clearSelectFile() {
      if (!window.addEventListener) {
        document.getElementById("input_draw_file").outerHTML += ""; //IE
      } else {
        document.getElementById("input_draw_file").value = ""; //FF
      }
    }
  
    $("#input_draw_file").change(function (e) {
      let file = this.files[0];
  
      let fileName = file.name;
      let fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length).toLowerCase();
  
      if (fileType == "json" || fileType == "geojson") {
        let reader = new FileReader();
        reader.readAsText(file, "UTF-8");
        reader.onloadend = function (e) {
          let json = this.result;
          graphicLayer.loadGeoJSON(json, {
            flyTo: true,
          });
          clearSelectFile();
        };
      } else if (fileType == "kml") {
        let reader = new FileReader();
        reader.readAsText(file, "UTF-8");
        reader.onloadend = function (e) {
          let strkml = this.result;
          kgUtil.toGeoJSON(strkml).then((geojoson) => {
            console.log("kml2geojson", geojoson);
  
            graphicLayer.loadGeoJSON(geojoson, {
              flyTo: true,
              // symbol: function (attr, style, featue) {
              //   let geoType = featue.geometry?.type
              //   if (geoType == 'Point') {
              //     return {
              //       image: 'img/marker/di3.png',
              //       verticalOrigin: Cesium.VerticalOrigin.BOTTOM,
              //       scale: 0.4,
              //       label: {
              //         text: attr.name,
              //         font_size: 18,
              //         color: '#ffffff',
              //         outline: true,
              //         outlineColor: '#000000',
              //         pixelOffsetY: -50,
              //         scaleByDistance: true,
              //         scaleByDistance_far: 990000,
              //         scaleByDistance_farValue: 0.3,
              //         scaleByDistance_near: 10000,
              //         scaleByDistance_nearValue: 1,
              //       },
              //     }
              //   }
              //   return style
              // },
            });
            clearSelectFile();
          });
          clearSelectFile();
        };
      } else if (fileType == "kmz") {
        //加载input文件控件的二进制流
        kgUtil.toGeoJSON(file).then((geojoson) => {
          console.log("kmz2geojson", geojoson);
  
          graphicLayer.loadGeoJSON(geojoson, {
            flyTo: true,
          });
          clearSelectFile();
        });
      } else {
        window.layer.msg("暂不支持 " + fileType + " 文件类型的数据！");
        clearSelectFile();
      }
    });
  }
  
  export function bindLayerPopup(graphicLayer) {
    graphicLayer.bindPopup(function (event) {
      //let attr = event.graphic?.attr || {};
      //attr.text = "围栏";
      // attr["视频"] = `<video src='http://data.mars3d.cn/file/video/lukou.mp4' controls autoplay style="width: 300px;" ></video>`;
  
      //return mars3d.Util.getTemplateHtml({ title: "围栏区域", template: "all", attr: attr });
      return mars3d.Util.getTemplateHtml({ title: "围栏区域", template: "all"});
    });
  }
  
  export function bindLayerContextMenu(graphicLayer,index) {
    let rowNameId = index;
    graphicLayer.bindContextMenu([
      // {
      //   text: "开始编辑对象",
      //   iconCls: "fa fa-edit",
      //   show: function (e) {
      //     let graphic = e.graphic;
      //     if (!graphic || !graphic.startEditing) {
      //       return false;
      //     }
      //     return !graphic.isEditing;
      //   },
      //   callback: function (e) {
      //     let graphic = e.graphic;
      //     if (!graphic) {
      //       return false;
      //     }
      //     if (graphic) {
      //       graphicLayer.startEditing(graphic);
      //     }
      //   },
      // },
      // {
      //   text: "停止编辑对象",
      //   iconCls: "fa fa-edit",
      //   show: function (e) {
      //     let graphic = e.graphic;
      //     if (!graphic) {
      //       return false;
      //     }
      //     return graphic.isEditing;
      //   },
      //   callback: function (e) {
      //     let graphic = e.graphic;
      //     if (!graphic) {
      //       return false;
      //     }
      //     if (graphic) {
      //       graphicLayer.stopEditing(graphic);
      //     }
      //   },
      // },
      // {
      //   text: "删除对象",
      //   iconCls: "fa fa-trash-o",
      //   show: (event) => {
      //     let graphic = event.graphic;
      //     if (!graphic || graphic.isDestroy) {
      //       return false;
      //     } else {
      //       return true;
      //     }
      //   },
      //   callback: function (e) {
      //     console.log(e);
      //     let graphic = e.graphic;
      //     if (!graphic) {
      //       return;
      //     }
      //     //console.log(rowNameId);
      //     HttpReq.truckDispatching.screenMapSetUpDel([rowNameId]).then((res) => {
      //       if(res.status == 400){
      //         this.$notify({
      //           title: res.msg,
      //           type: 'error',
      //           duration: 2500
      //         })
      //       }else{
      //         this.$notify({
      //           title: '删除成功！',
      //           type: 'success',
      //           duration: 2500
      //         });
      //       }
      //     })
      //     graphicLayer.removeGraphic(graphic);
      //   },
      // },
      {
        text: "计算长度",
        iconCls: "fa fa-medium",
        show: function (e) {
          let graphic = e.graphic;
          if (!graphic) {
            return false;
          }
          return (
            graphic.type === "polyline" ||
            graphic.type === "polylineP" ||
            graphic.type === "curve" ||
            graphic.type === "curveP" ||
            graphic.type === "polylineVolume" ||
            graphic.type === "polylineVolumeP" ||
            graphic.type === "corridor" ||
            graphic.type === "corridorP" ||
            graphic.type === "wall" ||
            graphic.type === "wallP"
          );
        },
        callback: function (e) {
          let graphic = e.graphic;
          let strDis = mars3d.MeasureUtil.formatDistance(graphic.distance);
          alert("该对象的长度为:" + strDis);
        },
      },
      // {
      //   text: "计算周长",
      //   iconCls: "fa fa-medium",
      //   show: function (e) {
      //     let graphic = e.graphic;
      //     if (!graphic) {
      //       return false;
      //     }
      //     return (
      //       graphic.type === "circle" ||
      //       graphic.type === "circleP" ||
      //       graphic.type === "rectangle" ||
      //       graphic.type === "rectangleP" ||
      //       graphic.type === "polygon" ||
      //       graphic.type === "polygonP"
      //     );
      //   },
      //   callback: function (e) {
      //     let graphic = e.graphic;
      //     let strDis = mars3d.MeasureUtil.formatDistance(graphic.distance);
      //     alert("该对象的周长为:" + strDis);
      //   },
      // },
      // {
      //   text: "计算面积",
      //   iconCls: "fa fa-reorder",
      //   show: function (e) {
      //     let graphic = e.graphic;
      //     if (!graphic) {
      //       return false;
      //     }
      //     return (
      //       graphic.type === "circle" ||
      //       graphic.type === "circleP" ||
      //       graphic.type === "rectangle" ||
      //       graphic.type === "rectangleP" ||
      //       graphic.type === "polygon" ||
      //       graphic.type === "polygonP" ||
      //       graphic.type === "scrollWall" ||
      //       graphic.type === "water"
      //     );
      //   },
      //   callback: function (e) {
      //     let graphic = e.graphic;
      //     let strArea = mars3d.MeasureUtil.formatArea(graphic.area);
      //     alert("该对象的面积为:" + strArea);
      //   },
      // },
    ]);
  }
  
  //也可以在单个Graphic上做个性化管理及绑定操作
  export function initGraphicManager(graphic,item) {
    //3.在graphic上绑定监听事件
    // graphic.on(mars3d.EventType.click, function(event) {
    //   console.log('监听graphic，单击了矢量对象', event)
    // })
    // graphic.on(mars3d.EventType.mouseOver, function(event) {
    //   console.log('监听graphic，鼠标移入了矢量对象', event)
    // })
    // graphic.on(mars3d.EventType.mouseOut, function(event) {
    //   console.log('监听graphic，鼠标移出了矢量对象', event)
    // })
  
    //绑定Tooltip
    // graphic.bindTooltip('我是graphic上绑定的Tooltip') //.openTooltip()
  
    //绑定Popup
    graphic.bindPopup(item);
  
    // 绑定右键菜单
    // graphic.bindContextMenu([
    //   {
    //     text: "删除对象[graphic绑定的]",
    //     iconCls: "fa fa-trash-o",
    //     callback: function (e) {
    //       let graphic = e.graphic;
    //       if (graphic) {
    //         graphic.remove();
    //       }
    //     },
    //   },
    // ]);
  
    //测试 颜色闪烁
    if (graphic.startFlicker) {
      graphic.startFlicker({
        time: 20, //闪烁时长（秒）
        maxAlpha: 0.5,
        color: Cesium.Color.YELLOW,
        onEnd: function () {
          //结束后回调
        },
      });
    }
  }
  
  //取区域内的随机图标
  export function randomPoint() {
    var jd = haoutil.math.random(116.1 * 1000, 116.6 * 1000) / 1000;
    var wd = haoutil.math.random(30.8 * 1000, 31.1 * 1000) / 1000;
    var height = haoutil.math.random(1000, 9000);
    return new mars3d.LatLngPoint(jd, wd, height);
  }

  // import * as mars3d from "mars3d"
// const Cesium = mars3d.Cesium

  // 获取平台内置的右键菜单
  export function getDefaultContextMenu(map) {
    const that = map.contextmenu

    return [
      // {
      //   text: "查看此处坐标",
      //   icon: mars3d.Icon.Coordinates,
      //   show: function (e) {
      //     return Cesium.defined(e.cartesian)
      //   },
      //   callback: (e) => {
      //     // 经纬度
      //     const mpt = mars3d.LngLatPoint.fromCartesian(e.cartesian)
      //     const ptNew = mars3d.PointTrans.proj4Trans([mpt.lng, mpt.lat], "EPSG:4326", mars3d.CRS.CGCS2000_GK_Zone_3)

      //     const inhtml = `
      //     经度:${mpt.lng}, 纬度:${mpt.lat}, 海拔:${mpt.alt},

      //     横坐标:${ptNew[0].toFixed(1)}, 纵坐标:${ptNew[1].toFixed(1)} (CGCS2000)
      //     `
      //     globalAlert(inhtml, "位置信息")
      //   }
      // },

      // {
      //   text: "查看当前视角",
      //   icon: mars3d.Icon.CameraInfo,
      //   callback: (e) => {
      //     const mpt = JSON.stringify(map.getCameraView())
      //     globalAlert(mpt, "当前视角信息")
      //   }
      // },
      // {
      //   text: "视角切换",
      //   icon: mars3d.Icon.Camera,
      //   children: [
      //     {
      //       text: "允许进入地下",
      //       icon: mars3d.Icon.UndergroundYes,
      //       show: function (e) {
      //         return map.scene.screenSpaceCameraController.enableCollisionDetection
      //       },
      //       callback: (e) => {
      //         map.scene.screenSpaceCameraController.enableCollisionDetection = false
      //       }
      //     },
      //     {
      //       text: "禁止进入地下",
      //       icon: mars3d.Icon.UndergroundNo,
      //       show: function (e) {
      //         return !map.scene.screenSpaceCameraController.enableCollisionDetection
      //       },
      //       callback: (e) => {
      //         map.scene.screenSpaceCameraController.enableCollisionDetection = true
      //       }
      //     },
      //     {
      //       text: "绕此处环绕飞行",
      //       icon: mars3d.Icon.RotatePointStart,
      //       show: function (e) {
      //         return e.cartesian && (!that.rotatePoint || !that.rotatePoint?.isStart)
      //       },
      //       callback: (e) => {
      //         if (!that.rotatePoint) {
      //           that.rotatePoint = new mars3d.thing.RotatePoint()
      //           map.addThing(that.rotatePoint)
      //         }
      //         that.rotatePoint.start(e.cartesian)
      //       }
      //     },
      //     {
      //       text: "关闭环绕飞行",
      //       icon: mars3d.Icon.RotatePointStop,
      //       show: function (e) {
      //         return that.rotatePoint?.isStart
      //       },
      //       callback: (e) => {
      //         if (that.rotatePoint) {
      //           that.rotatePoint.stop()
      //         }
      //       }
      //     },

      //     {
      //       text: "移动到此处",
      //       icon: mars3d.Icon.FlyToPoint,
      //       show: function (e) {
      //         return Cesium.defined(e.cartesian)
      //       },
      //       callback: (e) => {
      //         const cameraDistance = Cesium.Cartesian3.distance(e.cartesian, map.camera.positionWC) * 0.1

      //         map.flyToPoint(e.cartesian, {
      //           radius: cameraDistance, // 距离目标点的距离
      //           maximumHeight: map.camera.positionCartographic.height
      //         })
      //       }
      //     },
      //     {
      //       text: "第一视角站到此处",
      //       icon: mars3d.Icon.FirstPerspective,
      //       show: function (e) {
      //         return Cesium.defined(e.cartesian)
      //       },
      //       callback: (e) => {
      //         map.camera.flyTo({
      //           destination: mars3d.PointUtil.addPositionsHeight(e.cartesian, 10), // 升高10米
      //           orientation: {
      //             heading: map.camera.heading,
      //             pitch: 0.0,
      //             roll: 0.0
      //           },
      //           maximumHeight: map.camera.positionCartographic.height
      //         })
      //       }
      //     },
      //     {
      //       text: "开启键盘漫游",
      //       icon: mars3d.Icon.KeyboardRoamYes,
      //       show: function (e) {
      //         return !map.keyboardRoam.enabled
      //       },
      //       callback: (e) => {
      //         map.keyboardRoam.enabled = true
      //       }
      //     },
      //     {
      //       text: "关闭键盘漫游",
      //       icon: mars3d.Icon.KeyboardRoamNo,
      //       show: function (e) {
      //         return map.keyboardRoam.enabled
      //       },
      //       callback: (e) => {
      //         map.keyboardRoam.enabled = false
      //       }
      //     },
      //     {
      //       text: "取消锁定",
      //       icon: mars3d.Icon.TrackedEntityNo,
      //       show: function (e) {
      //         return map.trackedEntity !== undefined
      //       },
      //       callback: (e) => {
      //         map.trackedEntity = undefined
      //       }
      //     }
      //   ]
      // },
      // {
      //   text: "三维模型",
      //   icon: mars3d.Icon.Tileset,
      //   show: function (e) {
      //     const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //     return Cesium.defined(model)
      //   },
      //   children: [
      //     {
      //       text: "显示三角网",
      //       icon: mars3d.Icon.TilesetWireframeYes,
      //       show: function (e) {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         return !model.debugWireframe
      //       },
      //       callback: (e) => {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         model.debugWireframe = true
      //       }
      //     },
      //     {
      //       text: "关闭三角网",
      //       icon: mars3d.Icon.TilesetWireframeNo,
      //       show: function (e) {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         return model.debugWireframe
      //       },
      //       callback: (e) => {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         model.debugWireframe = false
      //       }
      //     },
      //     {
      //       text: "显示包围盒",
      //       icon: mars3d.Icon.TilesetBoundingVolumeYes,
      //       show: function (e) {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         return !model.debugShowBoundingVolume
      //       },
      //       callback: (e) => {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         model.debugShowBoundingVolume = true
      //       }
      //     },
      //     {
      //       text: "关闭包围盒",
      //       icon: mars3d.Icon.TilesetBoundingVolumeNo,
      //       show: function (e) {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         return model.debugShowBoundingVolume
      //       },
      //       callback: (e) => {
      //         const model = map.pick3DTileset(e.cartesian) // 拾取绘制返回的模型
      //         model.debugShowBoundingVolume = false
      //       }
      //     }
      //   ]
      // },

      // {
      //   text: "地形服务",
      //   icon: mars3d.Icon.Terrain,
      //   show: function (e) {
      //     return Cesium.defined(e.cartesian)
      //   },
      //   children: [
      //     {
      //       text: "开启地形",
      //       icon: mars3d.Icon.TerrainYes,
      //       show: function (e) {
      //         return !map.hasTerrain
      //       },
      //       callback: (e) => {
      //         map.hasTerrain = true
      //       }
      //     },
      //     {
      //       text: "关闭地形",
      //       icon: mars3d.Icon.TerrainNo,
      //       show: function (e) {
      //         return map.hasTerrain
      //       },
      //       callback: (e) => {
      //         map.hasTerrain = false
      //       }
      //     },
      //     {
      //       text: "显示三角网",
      //       icon: mars3d.Icon.TerrainWireframeYes,
      //       show: function (e) {
      //         return !map.scene.globe._surface.tileProvider._debug.wireframe
      //       },
      //       callback: (e) => {
      //         map.scene.globe._surface.tileProvider._debug.wireframe = true
      //       }
      //     },
      //     {
      //       text: "关闭三角网",
      //       icon: mars3d.Icon.TerrainWireframeNo,
      //       show: function (e) {
      //         return map.scene.globe._surface.tileProvider._debug.wireframe
      //       },
      //       callback: (e) => {
      //         map.scene.globe._surface.tileProvider._debug.wireframe = false
      //       }
      //     }
      //   ]
      // },
      {
        text: "图上量算",
        icon: mars3d.Icon.Measure,
        children: [
          {
            text: "距离",
            icon: mars3d.Icon.MeasureDistance,
            callback: (e) => {
              if (!that.measure) {
                that.measure = new mars3d.thing.Measure()
                map.addThing(that.measure)
              }
              that.measure.distance()
            }
          },
          // {
          //   text: "面积",
          //   icon: mars3d.Icon.MeasureArea,
          //   callback: (e) => {
          //     if (!that.measure) {
          //       that.measure = new mars3d.thing.Measure()
          //       map.addThing(that.measure)
          //     }
          //     that.measure.area()
          //   }
          // },
          // {
          //   text: "高度差",
          //   icon: mars3d.Icon.MeasureHeight,
          //   callback: (e) => {
          //     if (!that.measure) {
          //       that.measure = new mars3d.thing.Measure()
          //       map.addThing(that.measure)
          //     }
          //     that.measure.heightTriangle()
          //   }
          // },
          // {
          //   text: "角度",
          //   icon: mars3d.Icon.MeasureAngle,
          //   callback: (e) => {
          //     if (!that.measure) {
          //       that.measure = new mars3d.thing.Measure()
          //       map.addThing(that.measure)
          //     }
          //     that.measure.angle()
          //   }
          // },
          {
            text: "删除测量",
            icon: mars3d.Icon.Delete,
            show: function (e) {
              return that.measure && that.measure.hasMeasure
            },
            callback: (e) => {
              if (that.measure) {
                that.measure.clear()
              }
            }
          }
        ]
      },

      // {
      //   text: "图上标记",
      //   icon: mars3d.Icon.Draw,
      //   children: [
      //     {
      //       text: "标记点",
      //       icon: mars3d.Icon.DrawPoint,
      //       callback: (e) => {
      //         map.graphicLayer.startDraw({
      //           type: "point",
      //           style: {
      //             pixelSize: 12,
      //             color: "#3388ff"
      //           },
      //           success: function (graphic) {
      //             // eslint-disable-next-line no-console
      //             console.log(JSON.stringify(graphic.coordinates))
      //           }
      //         })
      //       }
      //     },
      //     {
      //       text: "标记线",
      //       icon: mars3d.Icon.DrawPolyline,
      //       callback: (e) => {
      //         map.graphicLayer.startDraw({
      //           type: "polyline",
      //           style: {
      //             color: "#55ff33",
      //             width: 3
      //           },
      //           success: function (graphic) {
      //             // eslint-disable-next-line no-console
      //             console.log(JSON.stringify(graphic.coordinates))
      //           }
      //         })
      //       }
      //     },
      //     {
      //       text: "标记面",
      //       icon: mars3d.Icon.DrawPolygon,
      //       callback: (e) => {
      //         map.graphicLayer.startDraw({
      //           type: "polygon",
      //           style: {
      //             color: "#29cf34",
      //             opacity: 0.5,
      //             outline: true,
      //             outlineWidth: 2.0
      //           },
      //           success: function (graphic) {
      //             // eslint-disable-next-line no-console
      //             console.log(JSON.stringify(graphic.coordinates))
      //           }
      //         })
      //       }
      //     },
      //     {
      //       text: "标记圆",
      //       icon: mars3d.Icon.DrawCircle,
      //       callback: (e) => {
      //         map.graphicLayer.startDraw({
      //           type: "circle",
      //           style: {
      //             color: "#ffff00",
      //             opacity: 0.6
      //           },
      //           success: function (graphic) {
      //             // eslint-disable-next-line no-console
      //             console.log(JSON.stringify(graphic.coordinates))
      //           }
      //         })
      //       }
      //     },
      //     {
      //       text: "标记矩形",
      //       icon: mars3d.Icon.DrawRectangle,
      //       callback: (e) => {
      //         map.graphicLayer.startDraw({
      //           type: "rectangle",
      //           style: {
      //             color: "#ffff00",
      //             opacity: 0.6
      //           },
      //           success: function (graphic) {
      //             // eslint-disable-next-line no-console
      //             console.log(JSON.stringify(graphic.coordinates))
      //           }
      //         })
      //       }
      //     },
      //     {
      //       text: "允许编辑",
      //       icon: mars3d.Icon.DrawEditYes,
      //       show: function (e) {
      //         return !map.graphicLayer.hasEdit
      //       },
      //       callback: (e) => {
      //         map.graphicLayer.hasEdit = true
      //       }
      //     },
      //     {
      //       text: "禁止编辑",
      //       icon: mars3d.Icon.DrawEditNo,
      //       show: function (e) {
      //         return map.graphicLayer.hasEdit
      //       },
      //       callback: (e) => {
      //         map.graphicLayer.hasEdit = false
      //       }
      //     },
      //     {
      //       text: "导出GeoJSON",
      //       icon: mars3d.Icon.DrawDownJson,
      //       show: function (e) {
      //         return map.graphicLayer.length > 0
      //       },
      //       callback: (e) => {
      //         mars3d.Util.downloadFile("图上标记.json", JSON.stringify(map.graphicLayer.toGeoJSON()))
      //       }
      //     },
      //     {
      //       text: "清除所有标记",
      //       icon: mars3d.Icon.Delete,
      //       show: function (e) {
      //         return map.graphicLayer.length > 0
      //       },
      //       callback: (e) => {
      //         map.graphicLayer.clear()
      //       }
      //     }
      //   ]
      // },
      // {
      //   text: "特效效果",
      //   icon: mars3d.Icon.Effect,
      //   children: [
      //     {
      //       text: "开启下雨",
      //       icon: mars3d.Icon.RainEffectYes,
      //       show: function (e) {
      //         return !that.rainEffect
      //       },
      //       callback: (e) => {
      //         if (!that.rainEffect) {
      //           that.rainEffect = new mars3d.effect.RainEffect()
      //           map.addEffect(that.rainEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭下雨",
      //       icon: mars3d.Icon.RainEffectNo,
      //       show: function (e) {
      //         return that.rainEffect
      //       },
      //       callback: (e) => {
      //         if (that.rainEffect) {
      //           map.removeEffect(that.rainEffect, true)
      //           delete that.rainEffect
      //         }
      //       }
      //     },
      //     {
      //       text: "开启下雪",
      //       icon: mars3d.Icon.SnowEffectYes,
      //       show: function (e) {
      //         return !that.snowEffect
      //       },
      //       callback: (e) => {
      //         if (!that.snowEffect) {
      //           that.snowEffect = new mars3d.effect.SnowEffect()
      //           map.addEffect(that.snowEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭下雪",
      //       icon: mars3d.Icon.SnowEffectNo,
      //       show: function (e) {
      //         return that.snowEffect
      //       },
      //       callback: (e) => {
      //         if (that.snowEffect) {
      //           map.removeEffect(that.snowEffect, true)
      //           delete that.snowEffect
      //         }
      //       }
      //     },

      //     {
      //       text: "开启雾天气",
      //       icon: mars3d.Icon.FogEffectYes,
      //       show: function (e) {
      //         return !that.fogEffect
      //       },
      //       callback: (e) => {
      //         if (!that.fogEffect) {
      //           const height = map.camera.positionCartographic.height * 2
      //           that.fogEffect = new mars3d.effect.FogEffect({
      //             fogByDistance: new Cesium.Cartesian4(0.1 * height, 0.1, height, 0.8)
      //           })
      //           map.addEffect(that.fogEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭雾天气",
      //       icon: mars3d.Icon.FogEffectNo,
      //       show: function (e) {
      //         return that.fogEffect
      //       },
      //       callback: (e) => {
      //         if (that.fogEffect) {
      //           map.removeEffect(that.fogEffect, true)
      //           delete that.fogEffect
      //         }
      //       }
      //     },

      //     {
      //       text: "开启泛光",
      //       icon: mars3d.Icon.BloomEffectYes,
      //       show: function (e) {
      //         return !that.bloomEffect
      //       },
      //       callback: (e) => {
      //         if (!that.bloomEffect) {
      //           that.bloomEffect = new mars3d.effect.BloomEffect()
      //           map.addEffect(that.bloomEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭泛光",
      //       icon: mars3d.Icon.BloomEffectNo,
      //       show: function (e) {
      //         return that.bloomEffect
      //       },
      //       callback: (e) => {
      //         if (that.bloomEffect) {
      //           map.removeEffect(that.bloomEffect, true)
      //           delete that.bloomEffect
      //         }
      //       }
      //     },

      //     {
      //       text: "开启亮度",
      //       icon: mars3d.Icon.BrightnessEffectYes,
      //       show: function (e) {
      //         return !that.brightnessEffect
      //       },
      //       callback: (e) => {
      //         if (!that.brightnessEffect) {
      //           that.brightnessEffect = new mars3d.effect.BrightnessEffect()
      //           map.addEffect(that.brightnessEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭亮度",
      //       icon: mars3d.Icon.BrightnessEffectNo,
      //       show: function (e) {
      //         return that.brightnessEffect
      //       },
      //       callback: (e) => {
      //         if (that.brightnessEffect) {
      //           map.removeEffect(that.brightnessEffect, true)
      //           delete that.brightnessEffect
      //         }
      //       }
      //     },

      //     {
      //       text: "开启夜视",
      //       icon: mars3d.Icon.NightVisionEffectYes,
      //       show: function (e) {
      //         return !that.nightVisionEffect
      //       },
      //       callback: (e) => {
      //         if (!that.nightVisionEffect) {
      //           that.nightVisionEffect = new mars3d.effect.NightVisionEffect()
      //           map.addEffect(that.nightVisionEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭夜视",
      //       icon: mars3d.Icon.NightVisionEffectNo,
      //       show: function (e) {
      //         return that.nightVisionEffect
      //       },
      //       callback: (e) => {
      //         if (that.nightVisionEffect) {
      //           map.removeEffect(that.nightVisionEffect, true)
      //           delete that.nightVisionEffect
      //         }
      //       }
      //     },

      //     {
      //       text: "开启黑白",
      //       icon: mars3d.Icon.BlackAndWhiteEffectYes,
      //       show: function (e) {
      //         return !that.blackAndWhiteEffect
      //       },
      //       callback: (e) => {
      //         if (!that.blackAndWhiteEffect) {
      //           that.blackAndWhiteEffect = new mars3d.effect.BlackAndWhiteEffect()
      //           map.addEffect(that.blackAndWhiteEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭黑白",
      //       icon: mars3d.Icon.BlackAndWhiteEffectNo,
      //       show: function (e) {
      //         return that.blackAndWhiteEffect
      //       },
      //       callback: (e) => {
      //         if (that.blackAndWhiteEffect) {
      //           map.removeEffect(that.blackAndWhiteEffect, true)
      //           delete that.blackAndWhiteEffect
      //         }
      //       }
      //     },

      //     {
      //       text: "开启拾取高亮",
      //       icon: mars3d.Icon.OutlineEffectYes,
      //       show: function (e) {
      //         return !that.outlineEffect
      //       },
      //       callback: (e) => {
      //         if (!that.outlineEffect) {
      //           that.outlineEffect = new mars3d.effect.OutlineEffect()
      //           map.addEffect(that.outlineEffect)
      //         }
      //       }
      //     },
      //     {
      //       text: "关闭拾取高亮",
      //       icon: mars3d.Icon.OutlineEffectNo,
      //       show: function (e) {
      //         return that.outlineEffect
      //       },
      //       callback: (e) => {
      //         if (that.outlineEffect) {
      //           map.removeEffect(that.outlineEffect, true)
      //           delete that.outlineEffect
      //         }
      //       }
      //     }
      //   ]
      // },
      // {
      //   text: "场景设置",
      //   icon: mars3d.Icon.Scene,
      //   children: [
      //     {
      //       text: "开启深度监测",
      //       icon: mars3d.Icon.DepthTestYes,
      //       show: function (e) {
      //         return !map.scene.globe.depthTestAgainstTerrain
      //       },
      //       callback: (e) => {
      //         map.scene.globe.depthTestAgainstTerrain = true
      //       }
      //     },
      //     {
      //       text: "关闭深度监测",
      //       icon: mars3d.Icon.DepthTestNo,
      //       show: function (e) {
      //         return map.scene.globe.depthTestAgainstTerrain
      //       },
      //       callback: (e) => {
      //         map.scene.globe.depthTestAgainstTerrain = false
      //       }
      //     },

      //     {
      //       text: "显示星空背景",
      //       icon: mars3d.Icon.SkyBoxYes,
      //       show: function (e) {
      //         return !map.scene.skyBox.show
      //       },
      //       callback: (e) => {
      //         map.scene.skyBox.show = true // 天空盒
      //         map.scene.moon.show = true // 太阳
      //         map.scene.sun.show = true // 月亮
      //       }
      //     },
      //     {
      //       text: "关闭星空背景",
      //       icon: mars3d.Icon.SkyBoxNo,
      //       show: function (e) {
      //         return map.scene.skyBox.show
      //       },
      //       callback: (e) => {
      //         map.scene.skyBox.show = false // 天空盒
      //         map.scene.moon.show = false // 太阳
      //         map.scene.sun.show = false // 月亮
      //       }
      //     },
      //     {
      //       text: "开启日照阴影",
      //       icon: mars3d.Icon.ShadowYes,
      //       show: function (e) {
      //         return !map.viewer.shadows
      //       },
      //       callback: (e) => {
      //         map.viewer.shadows = true
      //         map.viewer.terrainShadows = Cesium.ShadowMode.ENABLED
      //         map.scene.globe.enableLighting = true
      //       }
      //     },
      //     {
      //       text: "关闭日照阴影",
      //       icon: mars3d.Icon.ShadowNo,
      //       show: function (e) {
      //         return map.viewer.shadows
      //       },
      //       callback: (e) => {
      //         map.viewer.shadows = false
      //         map.viewer.terrainShadows = Cesium.ShadowMode.RECEIVE_ONLY
      //         map.scene.globe.enableLighting = false
      //       }
      //     },
      //     {
      //       text: "开启大气渲染",
      //       icon: mars3d.Icon.SkyAtmosphereYes,
      //       show: function (e) {
      //         return !map.scene.skyAtmosphere.show
      //       },
      //       callback: (e) => {
      //         map.scene.skyAtmosphere.show = true
      //         map.scene.globe.showGroundAtmosphere = true
      //       }
      //     },
      //     {
      //       text: "关闭大气渲染",
      //       icon: mars3d.Icon.SkyAtmosphereNo,
      //       show: function (e) {
      //         return map.scene.skyAtmosphere.show
      //       },
      //       callback: (e) => {
      //         map.scene.skyAtmosphere.show = false
      //         map.scene.globe.showGroundAtmosphere = false
      //       }
      //     },

      //     {
      //       text: "场景出图",
      //       icon: mars3d.Icon.ExpImage,
      //       callback: (e) => {
      //         map.expImage()
      //       }
      //     }
      //   ]
      // }
    ]
  }

  