
import request from '@/utils/request';
var baseAPI2 = process.env.VUE_APP_LOCAL_API2 + '/';

var HttpReq = function(){
	return {
		//卡车调度系统
		truckDispatching:{
			//图片上传
			uploadPictures: function(data){
				return request({
					url: '/api/Area/updateAvatar',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			//系统管理——班次设置
			shiftQuery: function(param){
				return request({
					url: '/api/Class',
					method: 'get',
					params:param,
				})
			},
			shiftAdd: function(data){
				return request({
					url: '/api/Class',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			shiftUpdate: function(data){
				return request({
					url: '/api/Class',
					method: 'PUT',
					data:data,
				})
			},
			shiftDel: function(data){
				return request({
					url: '/api/Class',
					method: 'Delete',
					data:data,
				})
			},
			//系统管理——数据字典设置
			dataDictionaryQuery: function(param){
				return request({
					url: '/api/Threshold',
					method: 'get',
					params:param,
				})
			},
			dataDictionaryAdd: function(data){
				return request({
					url: '/api/Threshold',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			dataDictionaryUpdate: function(data){
				return request({
					url: '/api/Threshold',
					method: 'PUT',
					data:data,
				})
			},
			dataDictionaryDel: function(data){
				return request({
					url: '/api/Threshold',
					method: 'Delete',
					data:data,
				})
			},
			//系统管理——数据字典——报警时长
			alarmTimeQuery: function(param){
				return request({
					url: '/api/AlarmTime',
					method: 'get',
					params:param,
				})
			},
			alarmTimeAdd: function(data){
				return request({
					url: '/api/AlarmTime',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			alarmTimeUpdate: function(data){
				return request({
					url: '/api/AlarmTime',
					method: 'PUT',
					data:data,
				})
			},
			alarmTimetDel: function(data){
				return request({
					url: '/api/AlarmTime',
					method: 'Delete',
					data:data,
				})
			},
			//系统管理——数据字典——疲劳驾驶
			fdriTimeQuery: function(param){
				return request({
					url: '/api/FdriTime',
					method: 'get',
					params:param,
				})
			},
			fdriTimeAdd: function(data){
				return request({
					url: '/api/FdriTime',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			fdriTimeUpdate: function(data){
				return request({
					url: '/api/FdriTime',
					method: 'PUT',
					data:data,
				})
			},
			fdriTimetDel: function(data){
				return request({
					url: '/api/FdriTime',
					method: 'Delete',
					data:data,
				})
			},
			//系统管理——数据字典——优先级设置
			getPriorityQuery: function(param){
				return request({
					url: '/api/Pri',
					method: 'get',
					params:param,
				})
			},
			getPriorityTimeAdd: function(data){
				return request({
					url: '/api/Pri',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			getPriorityTimeUpdate: function(data){
				return request({
					url: '/api/Pri',
					method: 'PUT',
					data:data,
				})
			},
			getPriorityTimetDel: function(data){
				return request({
					url: '/api/Pri',
					method: 'Delete',
					data:data,
				})
			},
			//系统管理——数据字典——月统计设置
			monthStatisticsQuery: function(param){
				return request({
					url: '/api/Month',
					method: 'get',
					params:param,
				})
			},
			monthStatisticsAdd: function(data){
				return request({
					url: '/api/Month',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			monthStatisticsUpdate: function(data){
				return request({
					url: '/api/Month',
					method: 'PUT',
					data:data,
				})
			},
			monthStatisticsDel: function(data){
				return request({
					url: '/api/Month',
					method: 'Delete',
					data:data,
				})
			},
			//系统管理——数据字典——通知频率设置
			notifiyFrequencyQuery: function(param){
				return request({
					url: '/api/Hz',
					method: 'get',
					params:param,
				})
			},
			notifiyFrequencyAdd: function(data){
				return request({
					url: '/api/Hz',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			notifiyFrequencyUpdate: function(data){
				return request({
					url: '/api/Hz',
					method: 'PUT',
					data:data,
				})
			},
			notifiyFrequencyDel: function(data){
				return request({
					url: '/api/Hz',
					method: 'Delete',
					data:data,
				})
			},
			//司机管理——人员管理
			driverManagementPCQuery: function(param){
				return request({
					url: '/api/Drivers',
					method: 'get',
					params:param,
				})
			},
			driverManagementPCAdd: function(data){
				return request({
					url: '/api/Drivers',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			driverManagementPCUpdate: function(data){
				return request({
					url: '/api/Drivers',
					method: 'PUT',
					data:data,
				})
			},
			driverManagementPCDel: function(data){
				return request({
					url: '/api/Drivers',
					method: 'Delete',
					data:data,
				})
			},
			//车辆管理——车辆类型
			carTypeQuery: function(param){
				return request({
					url: '/api/CarClass',
					method: 'get',
					params:param,
				})
			},
			carTypeAdd: function(data){
				return request({
					url: '/api/CarClass',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carTypeUpdate: function(data){
				return request({
					url: '/api/CarClass',
					method: 'PUT',
					data:data,
				})
			},
			carTypeDel: function(data){
				return request({
					url: '/api/CarClass',
					method: 'Delete',
					data:data,
				})
			},
			//车辆管理——车辆型号
			carModelQuery: function(param){
				return request({
					url: '/api/CarModel',
					method: 'get',
					params:param,
				})
			},
			carModelAdd: function(data){
				return request({
					url: '/api/CarModel',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carModelUpdate: function(data){
				return request({
					url: '/api/CarModel',
					method: 'PUT',
					data:data,
				})
			},
			carModelDel: function(data){
				return request({
					url: '/api/CarModel',
					method: 'Delete',
					data:data,
				})
			},
			//车辆管理——车队管理
			carFleetQuery: function(param){
				return request({
					url: '/api/CarRoad',
					method: 'get',
					params:param,
				})
			},
			carFleetAdd: function(data){
				return request({
					url: '/api/CarRoad',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carFleetUpdate: function(data){
				return request({
					url: '/api/CarRoad',
					method: 'PUT',
					data:data,
				})
			},
			carFleetDel: function(data){
				return request({
					url: '/api/CarRoad',
					method: 'Delete',
					data:data,
				})
			},
			//车辆管理——车辆信息
			carInformationQuery: function(param){
				return request({
					url: '/api/CarPeop',
					method: 'get',
					params:param,
				})
			},
			carInformationAdd: function(data){
				return request({
					url: '/api/CarPeop',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carInformationUpdate: function(data){
				return request({
					url: '/api/CarPeop',
					method: 'PUT',
					data:data,
				})
			},
			carInformationDel: function(data){
				return request({
					url: '/api/CarPeop',
					method: 'Delete',
					data:data,
				})
			},
			//车辆管理——车辆信息状态1
			carPeopStatus1Query: function(param){
				return request({
					url: '/api/CarPeop/status',
					method: 'get',
					params:param,
				})
			},
			//车辆管理——选择配对的终端设备
			selectZhongDuanDeviceQuery: function(param){
				return request({
					url: '/api/Equipment/use',
					method: 'get',
					params:param,
				})
			},
			//车辆管理——故障类型管理
			carFaultTypeQuery: function(param){
				return request({
					url: '/api/BreakClass',
					method: 'get',
					params:param,
				})
			},
			carFaultTypeUpAdd: function(data){
				return request({
					url: '/api/BreakClass',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carFaultTypeUpdate: function(data){
				return request({
					url: '/api/BreakClass',
					method: 'PUT',
					data:data,
				})
			},
			carFaultTypeDel: function(data){
				return request({
					url: '/api/BreakClass',
					method: 'Delete',
					data:data,
				})
			},
			//车辆管理——车辆故障管理
			carFaultQuery: function(param){
				return request({
					url: '/api/CarBreak',
					method: 'get',
					params:param,
				})
			},
			carFaultAdd: function(data){
				return request({
					url: '/api/CarBreak',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carFaultUpdate: function(data){
				return request({
					url: '/api/CarBreak',
					method: 'PUT',
					data:data,
				})
			},
			carFaultDel: function(data){
				return request({
					url: '/api/CarBreak',
					method: 'Delete',
					data:data,
				})
			},
			//车辆管理——车辆维修管理
			carRepairQuery: function(param){
				return request({
					url: '/api/CarRepair',
					method: 'get',
					params:param,
				})
			},
			carRepairAdd: function(data){
				return request({
					url: '/api/CarRepair',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carRepairUpdate: function(data){
				return request({
					url: '/api/CarRepair',
					method: 'PUT',
					data:data,
				})
			},
			carRepairDel: function(data){
				return request({
					url: '/api/CarRepair',
					method: 'Delete',
					data:data,
				})
			},
			//区域管理——区域类别设置
			RegionalTypeQuery: function(param){
				return request({
					url: '/api/Area',
					method: 'get',
					params:param,
				})
			},
			RegionalTypeAdd: function(data){
				return request({
					url: '/api/Area',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			RegionalTypeUpdate: function(data){
				return request({
					url: '/api/Area',
					method: 'PUT',
					data:data,
				})
			},
			RegionalTypeDel: function(data){
				return request({
					url: '/api/Area',
					method: 'Delete',
					data:data,
				})
			},
			//区域管理——区域信息设置
			RegionalInformationQuery: function(param){
				return request({
					url: '/api/AreaNew',
					method: 'get',
					params:param,
				})
			},
			RegionalInformationAdd: function(data){
				return request({
					url: '/api/AreaNew',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			RegionalInformationUpdate: function(data){
				return request({
					url: '/api/AreaNew',
					method: 'PUT',
					data:data,
				})
			},
			RegionalInformationDel: function(data){
				return request({
					url: '/api/AreaNew',
					method: 'Delete',
					data:data,
				})
			},
			//区域管理——采点管理设置
			RegionalCaiDianQuery: function(param){
				return request({
					url: '/api/AreaPoint',
					method: 'get',
					params:param,
				})
			},
			RegionalCaiDianAdd: function(data){
				return request({
					url: '/api/AreaPoint',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			RegionalCaiDianUpdate: function(data){
				return request({
					url: '/api/AreaPoint',
					method: 'PUT',
					data:data,
				})
			},
			RegionalCaiDianDel: function(data){
				return request({
					url: '/api/AreaPoint',
					method: 'Delete',
					data:data,
				})
			},
			//区域管理——区域信息设置——品位设置
			RegionalInformationGradeQuery: function(param){
				return request({
					url: '/api/AreaTaste',
					method: 'get',
					params:param,
				})
			},
			RegionalInformationGradeAdd: function(data){
				return request({
					url: '/api/AreaTaste',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			RegionalInformationGradeUpdate: function(data){
				return request({
					url: '/api/AreaTaste',
					method: 'PUT',
					data:data,
				})
			},
			RegionalInformationGradeDel: function(data){
				return request({
					url: '/api/AreaTaste',
					method: 'Delete',
					data:data,
				})
			},
			//区域管理——区域信息设置——选择车辆设置
			RegionalInformationCarQuery: function(param){
				return request({
					url: '/api/AreaCar',
					method: 'get',
					params:param,
				})
			},
			RegionalInformationCarAdd: function(data){
				return request({
					url: '/api/AreaCar',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			RegionalInformationCarUpdate: function(data){
				return request({
					url: '/api/AreaCar',
					method: 'PUT',
					data:data,
				})
			},
			RegionalInformationCarDel: function(data){
				return request({
					url: '/api/AreaCar',
					method: 'Delete',
					data:data,
				})
			},
			//视频监控——矿山监控管理——分区管理
			mineMonitoringPartitionQuery: function(param){
				return request({
					url: '/camera/list',
					method: 'get',
					params:param,
				})
			},
			mineMonitoringPartitionAdd: function(data){
				return request({
					url: '/camera/addCamera',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			mineMonitoringPartitionUpdate: function(data){
				return request({
					url: '/camera/updateCamera',
					method: 'PUT',
					data:data,
				})
			},
			mineMonitoringPartitionDel: function(data){
				return request({
					url: '/camera/delCamera',
					method: 'Delete',
					data:data,
				})
			},
			//视频监控——矿山监控管理——摄像头详细管理
			mineMonitoringCameraQuery: function(param){
				return request({
					url: '/cameraDetail/list',
					method: 'get',
					params:param,
				})
			},
			mineMonitoringCameraAdd: function(data){
				return request({
					url: '/cameraDetail/addCameraDetail',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			mineMonitoringCameraDel: function(data){
				return request({
					url: '/cameraDetail/delCameraDetail',
					method: 'Delete',
					data:data,
				})
			},
			//视频监控——矿山监控——摄像头萤石云视频监控获取token
			mineMonitoringGetTokenaQuery: function(param){
				return request({
					url: '/cameraDetail/token',
					method: 'get',
					params:param,
				})
			},
			//视频监控——矿山监控——摄像头视频监控云台控制判断有无
			mineMonitoringHowYuntaiQuery: function(param){
				return request({
					url: '/cameraDetail/yuntai',
					method: 'get',
					params:param,
				})
			},
			//视频监控——车辆监控管理——车队管理
			carMonitoringFleetQuery: function(param){
				return request({
					url: '/Car/list',
					method: 'get',
					params:param,
				})
			},
			carMonitoringFleetAdd: function(data){
				return request({
					url: '/Car/addCamera',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carMonitoringFleetUpdate: function(data){
				return request({
					url: '/Car/updateCamera',
					method: 'PUT',
					data:data,
				})
			},
			carMonitoringFleetDel: function(data){
				return request({
					url: '/Car/delCamera',
					method: 'Delete',
					data:data,
				})
			},
			//视频监控——车辆监控管理——车辆详细管理
			carMonitoringCarsQuery: function(param){
				return request({
					url: '/api/CarCamera',
					method: 'get',
					params:param,
				})
			},
			carMonitoringCarsAdd: function(data){
				return request({
					url: '/api/CarCamera',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carMonitoringCarsDel: function(data){
				return request({
					url: '/api/CarCamera',
					method: 'Delete',
					data:data,
				})
			},
			//生产计划管理——总生产计划设置
			productionPlanAllQuery: function(param){
				return request({
					url: '/api/Plan',
					method: 'get',
					params:param,
				})
			},
			productionPlanAllAdd: function(data){
				return request({
					url: '/api/Plan',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			productionPlanAllUpdate: function(data){
				return request({
					url: '/api/Plan',
					method: 'PUT',
					data:data,
				})
			},
			productionPlanAllDel: function(data){
				return request({
					url: '/api/Plan',
					method: 'Delete',
					data:data,
				})
			},
			//生产计划管理——各采区计划设置
			productionPlanNewAllQuery: function(param){
				return request({
					url: '/api/PlanNews',
					method: 'get',
					params:param,
				})
			},
			productionPlanNewAllAdd: function(data){
				return request({
					url: '/api/PlanNew',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			productionPlanNewAllUpdate: function(data){
				return request({
					url: '/api/PlanNew',
					method: 'PUT',
					data:data,
				})
			},
			productionPlanNewAllDel: function(data){
				return request({
					url: '/api/PlanNew',
					method: 'Delete',
					data:data,
				})
			},
			//设备管理——设备管理
			deviceManagementQuery: function(param){
				return request({
					url: '/api/Equipment',
					method: 'get',
					params:param,
				})
			},
			deviceManagementAdd: function(data){
				return request({
					url: '/api/Equipment',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			deviceManagementUpdate: function(data){
				return request({
					url: '/api/Equipment',
					method: 'PUT',
					data:data,
				})
			},
			deviceManagementDel: function(data){
				return request({
					url: '/api/Equipment',
					method: 'Delete',
					data:data,
				})
			},
			//设备管理——添加通信账号
			communicationAccountAdd: function(data){
				return request({
					url: '/instantMessage/createUsers',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			//设备管理——删除通信账号
			communicationAccountDel: function(data){
				return request({
					url: '/instantMessage/deleteUsers',
					method: 'Delete',
					data:data,
				})
			},
			//设备管理——报警管理1
			callPoliceQuery: function(param){
				return request({
					url: '/api/Alarm',
					method: 'get',
					params:param,
				})
			},
			callPoliceAdd: function(data){
				return request({
					url: '/api/Alarm',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			callPoliceUpdate: function(data){
				return request({
					url: '/api/Alarm',
					method: 'PUT',
					data:data,
				})
			},
			callPoliceDel: function(data){
				return request({
					url: '/api/Alarm',
					method: 'Delete',
					data:data,
				})
			},
			//设备管理——报警管理2
			callPoliceHistroyQuery: function(param){
				return request({
					url: '/mineAlarmHistory',
					method: 'get',
					params:param,
				})
			},
			callPoliceHistroyAdd: function(data){
				return request({
					url: '/mineAlarmHistory',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			callPoliceHistroyUpdate: function(data){
				return request({
					url: '/mineAlarmHistory',
					method: 'PUT',
					data:data,
				})
			},
			callPoliceHistroyDel: function(data){
				return request({
					url: '/mineAlarmHistory',
					method: 'Delete',
					data:data,
				})
			},
			//智能派单——智能派单历史数据
			IntelligentDispatchHistoryQuery: function(param){
				return request({
					url: '/api/Dispatch',
					method: 'get',
					params:param,
				})
			},
			IntelligentDispatchHistoryAdd: function(data){
				return request({
					url: '/api/Dispatch',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			IntelligentDispatchHistoryUpdate: function(data){
				return request({
					url: '/api/Dispatch',
					method: 'PUT',
					data:data,
				})
			},
			IntelligentDispatchHistoryDel: function(data){
				return request({
					url: '/api/Dispatch',
					method: 'Delete',
					data:data,
				})
			},
			//智能派单——人工调度1
			manualSchedulingQuery: function(param){
				return request({
					url: '/api/Manmade',
					method: 'get',
					params:param,
				})
			},
			manualSchedulingAdd: function(data){
				return request({
					url: '/api/Manmade',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			manualSchedulingUpdate: function(data){
				return request({
					url: '/api/Manmade',
					method: 'PUT',
					data:data,
				})
			},
			manualSchedulingDel: function(data){
				return request({
					url: '/api/Manmade',
					method: 'Delete',
					data:data,
				})
			},
			//智能派单——人工调度2
			manualOrderQuery: function(param){
				return request({
					url: '/api/Order',
					method: 'get',
					params:param,
				})
			},
			manualOrderAdd: function(data){
				return request({
					url: '/api/Order',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			manualOrderUpdate: function(data){
				return request({
					url: '/api/Order',
					method: 'PUT',
					data:data,
				})
			},
			manualOrderDel: function(data){
				return request({
					url: '/api/Order',
					method: 'Delete',
					data:data,
				})
			},
			//智能派单——人工调度所属调度车辆
			manualSchedulingCarsQuery: function(param){
				return request({
					url: '/api/Man',
					method: 'get',
					params:param,
				})
			},
			manualSchedulingCarsAdd: function(data){
				return request({
					url: '/api/Man',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			manualSchedulingCarsUpdate: function(data){
				return request({
					url: '/api/Man',
					method: 'PUT',
					data:data,
				})
			},
			manualSchedulingCarsDel: function(data){
				return request({
					url: '/api/Man',
					method: 'Delete',
					data:data,
				})
			},
			//智能派单——人工补录
			personRecordingQuery: function(param){
				return request({
					url: '/api/Manmades',
					method: 'get',
					params:param,
				})
			},
			personRecordingAdd: function(data){
				return request({
					url: '/api/Manmades',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			personRecordingUpdate: function(data){
				return request({
					url: '/api/Manmades',
					method: 'PUT',
					data:data,
				})
			},
			personRecordingDel: function(data){
				return request({
					url: '/api/Manmades',
					method: 'Delete',
					data:data,
				})
			},
			//智能派单——人工调度所属调度车辆
			personRecordingCarsQuery: function(param){
				return request({
					url: '/api/Mans',
					method: 'get',
					params:param,
				})
			},
			personRecordingCarsAdd: function(data){
				return request({
					url: '/api/Mans',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			personRecordingCarsUpdate: function(data){
				return request({
					url: '/api/Mans',
					method: 'PUT',
					data:data,
				})
			},
			personRecordingCarsDel: function(data){
				return request({
					url: '/api/Mans',
					method: 'Delete',
					data:data,
				})
			},
			//配矿管理——配矿管理
			RegionalOreBlendingQuery: function(param){
				return request({
					url: '/api/Ore',
					method: 'get',
					params:param,
				})
			},
			RegionalOreBlendingAdd: function(data){
				return request({
					url: '/api/Ore',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			RegionalOreBlendingUpdate: function(data){
				return request({
					url: '/api/Ore',
					method: 'PUT',
					data:data,
				})
			},
			RegionalOreBlendingDel: function(data){
				return request({
					url: '/api/Ore',
					method: 'Delete',
					data:data,
				})
			},

			//绩效统计——日报——区域产量报表采区
			caiquAreaQueryDay: function(param){
				return request({
					url: 'api/PlanNew/Day',
					method: 'get',
					params:param,
				})
			},
			caiquAreaAddDay: function(data){
				return request({
					url: 'api/PlanNew/Day',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			caiquAreaUpdateDay: function(data){
				return request({
					url: 'api/PlanNew/Day',
					method: 'PUT',
					data:data,
				})
			},
			caiquAreaDelDay: function(data){
				return request({
					url: 'api/PlanNew/Day',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——日报——区域产量报表卸区
			xiequAreaQueryDay: function(param){
				return request({
					url: '/api/Point',
					method: 'get',
					params:param,
				})
			},
			xiequAreaAddDay: function(data){
				return request({
					url: '/api/Point',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			xiequAreaUpdateDay: function(data){
				return request({
					url: '/api/Point',
					method: 'PUT',
					data:data,
				})
			},
			xiequAreaDelDay: function(data){
				return request({
					url: '/api/Point',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——日报——车辆产量报表
			carOutputQueryDay: function(param){
				return request({
					url: '/api/Car',
					method: 'get',
					params:param,
				})
			},
			carOutputAddDay: function(data){
				return request({
					url: '/api/Car',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carOutputUpdateDay: function(data){
				return request({
					url: '/api/Car',
					method: 'PUT',
					data:data,
				})
			},
			carOutputDelDay: function(data){
				return request({
					url: '/api/Car',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——日报——司机产量报表
			driverOutputQueryDay: function(param){
				return request({
					url: '/api/Driver',
					method: 'get',
					params:param,
				})
			},
			driverOutputAddDay: function(data){
				return request({
					url: '/api/Driver',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			driverOutputUpdateDay: function(data){
				return request({
					url: '/api/Driver',
					method: 'PUT',
					data:data,
				})
			},
			driverOutputDelDay: function(data){
				return request({
					url: '/api/Driver',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——日报——班次产量报表车辆
			carShiftOutputQueryDay: function(param){
				return request({
					url: '/api/Carshift',
					method: 'get',
					params:param,
				})
			},
			carShiftOutputAddDay: function(data){
				return request({
					url: '/api/Carshift',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carShiftOutputUpdateDay: function(data){
				return request({
					url: '/api/Carshift',
					method: 'PUT',
					data:data,
				})
			},
			carShiftOutputDelDay: function(data){
				return request({
					url: '/api/Carshift',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——日报——班次产量报表司机
			driverShiftOutputQueryDay: function(param){
				return request({
					url: '/api/Drivershift',
					method: 'get',
					params:param,
				})
			},
			driverShiftOutputAddDay: function(data){
				return request({
					url: '/api/Drivershift',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			driverShiftOutputUpdateDay: function(data){
				return request({
					url: '/api/Drivershift',
					method: 'PUT',
					data:data,
				})
			},
			driverShiftOutputDelDay: function(data){
				return request({
					url: '/api/Drivershift',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——日报——停车区域统计
			parkingQueryDay: function(param){
				return request({
					url: '/api/Stop',
					method: 'get',
					params:param,
				})
			},
			parkingAddDay: function(data){
				return request({
					url: '/api/Stop',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			parkingUpdateDay: function(data){
				return request({
					url: '/api/Stop',
					method: 'PUT',
					data:data,
				})
			},
			parkingDelDay: function(data){
				return request({
					url: '/api/Stop',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——日报——故障统计
			breakDownQueryDay: function(param){
				return request({
					url: '/api/Fault',
					method: 'get',
					params:param,
				})
			},
			breakDownAddDay: function(data){
				return request({
					url: '/api/Fault',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			breakDownUpdateDay: function(data){
				return request({
					url: '/api/Fault',
					method: 'PUT',
					data:data,
				})
			},
			breakDownDelDay: function(data){
				return request({
					url: '/api/Fault',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——区域产量报表采区
			caiquAreaQueryMonth: function(param){
				return request({
					url: '/api/PlanNew/Month',
					method: 'get',
					params:param,
				})
			},
			caiquAreaAddMonth: function(data){
				return request({
					url: '/api/PlanNew/Month',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			caiquAreaUpdateMonth: function(data){
				return request({
					url: '/api/PlanNew/Month',
					method: 'PUT',
					data:data,
				})
			},
			caiquAreaDelMonth: function(data){
				return request({
					url: '/api/PlanNew/Month',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——区域产量报表卸区
			xiequAreaQueryMonth: function(param){
				return request({
					url: '/api/PointMonth',
					method: 'get',
					params:param,
				})
			},
			xiequAreaAddMonth: function(data){
				return request({
					url: '/api/PointMonth',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			xiequAreaUpdateMonth: function(data){
				return request({
					url: '/api/PointMonth',
					method: 'PUT',
					data:data,
				})
			},
			xiequAreaDelMonth: function(data){
				return request({
					url: '/api/PointMonth',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——车辆产量报表
			carOutputQueryMonth: function(param){
				return request({
					url: '/api/CarMonth',
					method: 'get',
					params:param,
				})
			},
			carOutputAddMonth: function(data){
				return request({
					url: '/api/CarMonth',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carOutputUpdateMonth: function(data){
				return request({
					url: '/api/CarMonth',
					method: 'PUT',
					data:data,
				})
			},
			carOutputDelMonth: function(data){
				return request({
					url: '/api/CarMonth',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——司机产量报表
			driverOutputQueryMonth: function(param){
				return request({
					url: '/api/DriverMonth',
					method: 'get',
					params:param,
				})
			},
			driverOutputAddMonth: function(data){
				return request({
					url: '/api/DriverMonth',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			driverOutputUpdateMonth: function(data){
				return request({
					url: '/api/DriverMonth',
					method: 'PUT',
					data:data,
				})
			},
			driverOutputDelMonth: function(data){
				return request({
					url: '/api/DriverMonth',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——班次产量报表车辆
			carShiftOutputQueryMonth: function(param){
				return request({
					url: '/api/CarshiftMonth',
					method: 'get',
					params:param,
				})
			},
			carShiftOutputAddMonth: function(data){
				return request({
					url: '/api/CarshiftMonth',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carShiftOutputUpdateMonth: function(data){
				return request({
					url: '/api/CarshiftMonth',
					method: 'PUT',
					data:data,
				})
			},
			carShiftOutputDelMonth: function(data){
				return request({
					url: '/api/CarshiftMonth',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——班次产量报表司机
			driverShiftOutputQueryMonth: function(param){
				return request({
					url: '/api/DrivershiftMonth',
					method: 'get',
					params:param,
				})
			},
			driverShiftOutputAddMonth: function(data){
				return request({
					url: '/api/DrivershiftMonth',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			driverShiftOutputUpdateMonth: function(data){
				return request({
					url: '/api/DrivershiftMonth',
					method: 'PUT',
					data:data,
				})
			},
			driverShiftOutputDelMonth: function(data){
				return request({
					url: '/api/DrivershiftMonth',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——停车区域统计
			parkingQueryMonth: function(param){
				return request({
					url: '/api/StopMonth',
					method: 'get',
					params:param,
				})
			},
			parkingAddMonth: function(data){
				return request({
					url: '/api/StopMonth',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			parkingUpdateMonth: function(data){
				return request({
					url: '/api/StopMonth',
					method: 'PUT',
					data:data,
				})
			},
			parkingDelMonth: function(data){
				return request({
					url: '/api/StopMonth',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——月报——故障统计
			breakDownQueryMonth: function(param){
				return request({
					url: '/api/FaultMonth',
					method: 'get',
					params:param,
				})
			},
			breakDownAddMonth: function(data){
				return request({
					url: '/api/FaultMonth',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			breakDownUpdateMonth: function(data){
				return request({
					url: '/api/FaultMonth',
					method: 'PUT',
					data:data,
				})
			},
			breakDownDelMonth: function(data){
				return request({
					url: '/api/FaultMonth',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——区域产量报表采区
			caiquAreaQueryYear: function(param){
				return request({
					url: 'api/PlanNew/Year',
					method: 'get',
					params:param,
				})
			},
			caiquAreaAddYear: function(data){
				return request({
					url: 'api/PlanNew/Year',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			caiquAreaUpdateYear: function(data){
				return request({
					url: 'api/PlanNew/Year',
					method: 'PUT',
					data:data,
				})
			},
			caiquAreaDelYear: function(data){
				return request({
					url: 'api/PlanNew/Year',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——区域产量报表卸区
			xiequAreaQueryYear: function(param){
				return request({
					url: '/api/PointYear',
					method: 'get',
					params:param,
				})
			},
			xiequAreaAddYear: function(data){
				return request({
					url: '/api/PointYear',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			xiequAreaUpdateYear: function(data){
				return request({
					url: '/api/PointYear',
					method: 'PUT',
					data:data,
				})
			},
			xiequAreaDelYear: function(data){
				return request({
					url: '/api/PointYear',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——车辆产量报表
			carOutputQueryYear: function(param){
				return request({
					url: '/api/CarYear',
					method: 'get',
					params:param,
				})
			},
			carOutputAddYear: function(data){
				return request({
					url: '/api/CarYear',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carOutputUpdateYear: function(data){
				return request({
					url: '/api/CarYear',
					method: 'PUT',
					data:data,
				})
			},
			carOutputDelYear: function(data){
				return request({
					url: '/api/CarYear',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——司机产量报表
			driverOutputQueryYear: function(param){
				return request({
					url: '/api/DriverYear',
					method: 'get',
					params:param,
				})
			},
			driverOutputAddYear: function(data){
				return request({
					url: '/api/DriverYear',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			driverOutputUpdateYear: function(data){
				return request({
					url: '/api/DriverYear',
					method: 'PUT',
					data:data,
				})
			},
			driverOutputDelYear: function(data){
				return request({
					url: '/api/DriverYear',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——班次产量报表车辆
			carShiftOutputQueryYear: function(param){
				return request({
					url: '/api/CarshiftYear',
					method: 'get',
					params:param,
				})
			},
			carShiftOutputAddYear: function(data){
				return request({
					url: '/api/CarshiftYear',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			carShiftOutputUpdateYear: function(data){
				return request({
					url: '/api/CarshiftYear',
					method: 'PUT',
					data:data,
				})
			},
			carShiftOutputDelYear: function(data){
				return request({
					url: '/api/CarshiftYear',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——班次产量报表司机
			driverShiftOutputQueryYear: function(param){
				return request({
					url: '/api/DrivershiftYear',
					method: 'get',
					params:param,
				})
			},
			driverShiftOutputAddYear: function(data){
				return request({
					url: '/api/DrivershiftYear',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			driverShiftOutputUpdateYear: function(data){
				return request({
					url: '/api/DrivershiftYear',
					method: 'PUT',
					data:data,
				})
			},
			driverShiftOutputDelYear: function(data){
				return request({
					url: '/api/DrivershiftYear',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——停车区域统计
			parkingQueryYear: function(param){
				return request({
					url: '/api/StopYear',
					method: 'get',
					params:param,
				})
			},
			parkingAddYear: function(data){
				return request({
					url: '/api/StopYear',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			parkingUpdateYear: function(data){
				return request({
					url: '/api/StopYear',
					method: 'PUT',
					data:data,
				})
			},
			parkingDelYear: function(data){
				return request({
					url: '/api/StopYear',
					method: 'Delete',
					data:data,
				})
			},
			//绩效统计——年报——故障统计
			breakDownQueryYear: function(param){
				return request({
					url: '/api/FaultYear',
					method: 'get',
					params:param,
				})
			},
			breakDownAddYear: function(data){
				return request({
					url: '/api/FaultYear',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			breakDownUpdateYear: function(data){
				return request({
					url: '/api/FaultYear',
					method: 'PUT',
					data:data,
				})
			},
			breakDownDelYear: function(data){
				return request({
					url: '/api/FaultYear',
					method: 'Delete',
					data:data,
				})
			},
			//大屏——标题菜单
			screenTitleMenuQuery: function(param){
				return request({
					url: '/api/Title',
					method: 'get',
					params:param,
				})
			},
			screenTitleMenuAdd: function(data){
				return request({
					url: '/api/Title',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			screenTitleMenuUpdate: function(data){
				return request({
					url: '/api/Title',
					method: 'PUT',
					data:data,
				})
			},
			screenTitleMenuDel: function(data){
				return request({
					url: '/api/Title',
					method: 'Delete',
					data:data,
				})
			},
			//大屏——数据总览——采区产量统计——日产量
			apiPlanDayQuery: function(param){
				return request({
					url: '/api/Plan/Day',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——采区产量统计——月产量
			apiPlanMonthQuery: function(param){
				return request({
					url: '/api/Plan/Month',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——采区产量统计——年产量
			apiPlanYearQuery: function(param){
				return request({
					url: '/api/Plan/Year',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——司机信息
			screenDriverInformationQuery: function(param){
				return request({
					url: '/api/Drivers',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——获取天气
			getWeatherInforQuery: function(param){
				return request({
					url: '/api/Weather',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——车辆工时
			carWorkInforQuery: function(param){
				return request({
					url: '/api/Gongshi',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——卡车铲车排行榜
			kaChanRankListDayQuery: function(param){
				return request({
					url: '/api/Manmades/jiedanDay',
					method: 'get',
					params:param,
				})
			},
			kaChanRankListZhouQuery: function(param){
				return request({
					url: '/api/Manmades/jiedanZhou',
					method: 'get',
					params:param,
				})
			},
			kaChanRankListMouQuery: function(param){
				return request({
					url: '/api/Manmades/jiedanMou',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——中间下方图表
			apiPlanTime1Query: function(param){
				return request({
					url: '/api/Plan/time',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——运载数据
			apiPlanZDay1Query: function(param){
				return request({
					url: '/api/Plan/ZDay',
					method: 'get',
					params:param,
				})
			},
			//大屏——数据总览——装载数据
			apiPlanZMonth1Query: function(param){
				return request({
					url: '/api/Plan/ZMonth',
					method: 'get',
					params:param,
				})
			},
			//大屏——车辆管理——卡车铲车排行榜day
			apiManmadesDay1Query: function(param){
				return request({
					url: '/api/Manmades/Day',
					method: 'get',
					params:param,
				})
			},
			//大屏——车辆管理——卡车铲车排行榜week
			apiManmadesZhou1Query: function(param){
				return request({
					url: '/api/Manmades/Zhou',
					method: 'get',
					params:param,
				})
			},
			//大屏——车辆管理——卡车铲车排行榜month
			apiManmadesMou1Query: function(param){
				return request({
					url: '/api/Manmades/Mou',
					method: 'get',
					params:param,
				})
			},
			//大屏——智能调度——近期通知列表
			recentNoticeQuery: function(param){
				return request({
					url: '/api/Notice',
					method: 'get',
					params:param,
				})
			},
			recentNoticeAdd: function(data){
				return request({
					url: '/api/Notice',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			recentNoticeUpdate: function(data){
				return request({
					url: '/api/Notice',
					method: 'PUT',
					data:data,
				})
			},
			recentNoticeDel: function(data){
				return request({
					url: '/api/Notice',
					method: 'Delete',
					data:data,
				})
			},
			//大屏——智能调度——近期通知列表2
			screenDispatchWayAdd: function(data){
				return request({
					url: '/api/Dispatch/way',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			//大屏——数据分析——矿石产量比
			screenOreProportionDayQuery: function(param){
				return request({
					url: '/api/Mineral',
					method: 'get',
					params:param,
				})
			},
			screenOreProportionMonthQuery: function(param){
				return request({
					url: '/api/MineralMonth',
					method: 'get',
					params:param,
				})
			},
			screenOreProportionYearQuery: function(param){
				return request({
					url: '/api/MineralYear',
					method: 'get',
					params:param,
				})
			},
			//大屏——车辆信息弹框——车辆实时数据
			screenCarInforCarRealQuery: function(param){
				return request({
					url: '/api/CarReal',
					method: 'get',
					params:param,
				})
			},
			//大屏——车辆信息弹框——车辆实时数据
			screenCarInforCarRealQuery2: function(param){
				return request({
					url: '/api/CarPeop/realtime',
					method: 'get',
					params:param,
				})
			},
			//大屏——地图的增删改查
			screenMapSetUpQuery: function(param){
				return request({
					url: '/Weilan/list',
					method: 'get',
					params:param,
				})
			},
			screenMapSetUpAdd: function(data){
				return request({
					url: '/Weilan/addWeilan',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			screenMapSetUpUpdate: function(data){
				return request({
					url: '/Weilan/updateWeilan',
					method: 'PUT',
					data:data,
				})
			},
			screenMapSetUpDel: function(data){
				return request({
					url: '/Weilan/delWeilan',
					method: 'Delete',
					data:data,
				})
			},
			//获取地图车辆轨迹——获取所有实时坐标
			getCarTrajectoryQuery: function(param){
				return request({
					url: '/gps/all',
					method: 'get',
					params:param,
				})
			},
			//获取地图车辆轨迹——获取所有实时坐标
			getAllNewTimeCarTrajectoryQuery: function(param){
				return request({
					url: '/gps/all',
					method: 'get',
					params:param,
				})
			},
			//获取地图车辆轨迹——获取历史轨迹
			getAllHistroyCarTrajectoryQuery: function(param){
				return request({
					url: '/gps/line',
					method: 'get',
					params:param,
				})
			},
			//获取地图车辆轨迹——获取历史一个设备坐标
			getOneHistroyCarTrajectoryQuery: function(param){
				return request({
					url: '/gps',
					method: 'get',
					params:param,
				})
			},
			//车辆调度——只获取卸区接口
			onlyGetMiningAreaQuery: function(param){
				return request({
					url: '/api/AreaNew/class',
					method: 'get',
					params:param,
				})
			},
			//获取用于选择用户的用户名(全部用户名)
			getAllSystemUserNameQuery:function(param){
				return request({
					url: '/api/users',
					method: 'get',
					params:param,
				})
			},
			//获取用于选择用户的用户名(没用过的用户名)
			getNoUseSystemUserNameQuery:function(param){
				return request({
					url: '/api/users/use',
					method: 'get',
					params:param,
				})
			},
			//获取人员管理中的部门
			getAllDepartmentQuery:function(param){
				return request({
					url: '/api/dept',
					method: 'get',
					params:param,
				})
			},
			//获取人员管理中的岗位
			getAllPostQuery:function(param){
				return request({
					url: '/api/job',
					method: 'get',
					params:param,
				})
			},
			//大屏智能调度信息——进行中
			getLargeScreenUnder1: function(param){
				return request({
					url: '/api/Order/Under',
					method: 'get',
					params:param
				})
			},
			//大屏智能调度信息——已完成
			getLargeScreenRound1: function(param){
				return request({
					url: '/api/Order/Round',
					method: 'get',
					params:param
				})
			},
			//大屏智能调度信息列表
			getLargeScreen1: function(param){
				return request({
					url: '/api/Order/Start',
					method: 'get',
					params:param
				})
			},
			//大屏智能调度——车辆区域分布
			getLargeScreenfenbu1: function(param){
				return request({
					url: '/api/Dispatch/areaCar',
					method: 'get',
					params:param
				})
			},
			//大屏智能调度——采区车铲比
			getLargeScreenchechanbi1: function(param){
				return request({
					url: '/api/Dispatch/areaCarShovel',
					method: 'get',
					params:param
				})
			},
			//大屏数据分析——采区产量统计
			getApiHl1: function(param){
				return request({
					url: '/api/Hl',
					method: 'get',
					params:param
				})
			},
			
			


			








		},



		//华菱植物工厂
		plantFactory:{
			//管理员首页：客户总数 终端总数
			getCustomerTotal: function(){
				return request({
					url: '/register/list',
					method: 'get',
				})
			},
			//管理员首页：获取项目总数
			getProjectTotal: function(){
				return request({
					url: '/api/wProject/list',
					method: 'get',
				})
			},
			//管理员首页：传感器总数
			getSensorTotal: function(){
				return request({
					url: '/api/wEquipment/count',
					method: 'get',
				})
			},
			//管理员首页：设备在线
			getEquipmentOnlineTotal: function(){
				return request({
					url: '/api/wEquipment/online',
					method: 'get',
				})
			},
			//管理员首页：设备离线
			getEquipmentOfflineTotal: function(){
				return request({
					url: '/api/wEquipment/offline',
					method: 'get',
				})
			},
			//管理员首页：用户申请
			getUserApplicationTotal: function(){
				return request({
					url: '/register/enabled',
					method: 'get',
				})
			},
			//管理员首页：项目终端数量统计表
			getTerminalsStatisticsTotal: function(){
				return request({
					url: '/api/wRealtime/statistics',
					method: 'get',
				})
			},
			//管理员首页：传感器数目统计表
			getSensorTableList: function(){
				return request({
					url: '/register/enabled',
					method: 'get',
				})
			},
			//用户首页：获取轮播图
			getRotationChart: function(){
				return request({
					url: '/api/wProjectImg',
					method: 'get',
				})
			},
			//设备管理查询
			getDeviceManageList: function(param){
				return request({
					url: '/api/wEquipment',
					method: 'get',
					params:param,
				})
			},
			//设备管理添加
			addDeviceManageList: function(data){
				return request({
					url: '/api/wEquipment',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			//设备管理修改
			upDateDeviceManageList: function(data){
				return request({
					url: '/api/wEquipment',
					method: 'PUT',
					data:data,
				})
			},
			//设备管理删除
			removeDeviceManageList: function(data){
				return request({
					url: '/api/wEquipment',
					method: 'Delete',
					data:data,
				})
			},
			//大屏实时数据
			getLargeScreenNowDataList: function(param){
				return request({
					url: '/api/wRealtime',
					method: 'get',
					params:param
				})
			},
			//大屏报警列表
			getLargeScreenAlarmList: function(param){
				return request({
					url: '/api/wAlarm',
					method: 'get',
					params:param
				})
			},

		},
		/** 操作日志 */
		reoperationlog:{
			getLog: function (param, query) {
				return request({
					url: 'api/wOperationLog',
					method: 'get',
					data:query,
					params:param
				})
			}
		},
		/* 项目管理 */
		project:{
			// 获取项目
			getProject: function(param, query){
				return request({
					url: 'api/wProject',
					method: 'get',
					data:query,
					params:param
				})
			},
			getProjectInEquipment: function(param, query){
				return request({
					url: 'work/projectsInEquipment',
					method: 'get',
					data:query
				})
			},
			saveProject: function(data){
				return request({
					//url: 'work/projects',
					url: 'api/wProject',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			updateProject: function(data){
				return request({
					url: 'api/wProject',
					method: 'PUT',
					data:data,
				})
			},
			removeProject: function(data){
				return request({
					url: 'api/wProject',
					method: 'Delete',
					data:data,
				})
			},
			getPartList: function(){
				return request({
					url: 'work/projectsMinList',
					method: 'get',
				})
			},
		},
		/* 设备管理 */
		equipment:{
			/* 设备管理 */
			getItem: function(param, query){
				return request({
					url: 'work/equipment',
					method: 'get',
					data:query,
					params:param
				})
			},
			getSelectList: function(param, query){
				return request({
					url: 'work/equipmentSelectList',
					method: 'get',
					data:query,
					params:param
				})
			},
			saveItem: function(data){
				return request({
					url: 'work/equipment',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			updateItem: function(data){
				return request({
					url: 'work/equipment',
					method: 'put',
					data:data,
				})
			},
			removeItem: function(data){
				return request({
					url: 'work/equipment',
					method: 'delete',
					data:data,
				})
			},
			getItemById: function(param, query){
				return request({
					url: 'work/equipmentById',
					method: 'get',
					data:query,
					params:param
				})
			},
			getCount: function(param, query){
				return request({
					url: 'work/equipmentCount',
					method: 'get',
				})
			},
			// 指令下发
			setInstruction: function(param, query){
				var data = {url:baseAPI2 + 'api/instruction/sendIns', param:param};
				return request({
					url: 'biz/transmit',
					method: 'post',
					data:data,
				})
			},
			// 下发日志查看
			getInstructionLog: function(param, query){
				var data = {url:baseAPI2 + 'api/instruction/pageInsLog', param:param};
				return request({
					url: 'biz/transmit',
					method: 'get',
					params:data,
				})
			},
		},
		/* 图纸管理 */
		drawing:{
			/* 图纸管理 */
			getItem: function(param, query){
				return request({
					url: 'work/drawing',
					method: 'get',
					data:query,
					params:param
				})
			},
			/* 图纸列表关联points */
			getItemsInPoints: function(param, query){
				return request({
					url: 'work/drawingInPoints',
					method: 'get',
					data:query,
					params:param
				})
			},
			/* 图纸关联项目字段 */
			getItemSubProgram: function(param, query){
				return request({
					url: 'work/drawingSubProgram',
					method: 'get',
					data:query,
					params:param
				})
			},
			/* 图纸设备标记 */
			getNotInProgramSelectList: function(param, query){
				return request({
					url: 'work/drawingNotInProgramSelectList',
					method: 'get',
					data:query,
					params:param
				})
			},
			saveItem: function(data){
				return request({
					url: 'work/drawing',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			removeItem: function(data){
				return request({
					url: 'work/drawing',
					method: 'delete',
					data:data,
				})
			},
		},
		drawingpoint:{
			/* 图纸标记列表 */
			getItem: function(param, query){
				return request({
					url: 'work/drawingpoint',
					method: 'get',
					data:query,
					params:param
				})
			},
			
			/* 根据设备反向查询图纸设备标记 */
			getNotInDeviceSelectList: function(param, query){
				return request({
					url: 'work/drawpointNotInDeviceSelectList',
					method: 'get',
					data:query,
					params:param
				})
			},
			saveItem: function(data){
				return request({
					url: 'work/drawingpoint',
					method: 'POST',
					data:data,
				}).then((res) => {
					return res
				})
			},
			/* 更新 */
			updateItem: function(data){
				return request({
					url: 'work/drawingpoint',
					method: 'put',
					data:data,
				})
			},
		},
		/* 实时数据 */
		realtime:{
			/* 实时数据 */
			getItem: function(param, query){
				return request({
					url: 'work/realtime',
					method: 'get',
					data:query,
					params:param
				})
			},
			getItemByCodes: function(param, query){
				return request({
					url: 'work/realtimeByCodes',
					method: 'get',
					data:query,
					params:param
				})
			},
		},
		historys:{
			/* 历史记录 */
			getItem: function(param, query){
				return request({
					//url: 'work/history',
					url: 'api/wHistory',
					method: 'get',
					data:query,
					params:param
				})
			},
			/* 历史记录 */
			getItemBycode: function(param, query){
				return request({
					url: 'work/historyBycode',
					method: 'get',
					data:query,
					params:param
				})
			},
		},
		alarm:{
			/* 获取 */
			getItem: function(param, query){
				return request({
					url: 'work/alarm',
					method: 'get',
					data:query,
					params:param
				})
			},
			/* 报警列表关联项目信息 */
			getListByCodes: function(param, query){
				return request({
					url: 'work/alarmListByCodes',
					method: 'get',
					data:query,
					params:param
				})
			},
			// 按月份统计报警数量
			getItemOnMonthStatistics: function(param, query){
				return request({
					url: 'work/alarmOnMonthStatistics',
					method: 'get',
					data:query,
					params:param
				})
			},
			// 报警列表未解除
			getListNotSolve: function(param, query){
				return request({
					url: 'work/alarmListNotSolve',
					method: 'get',
					data:query,
					params:param
				})
			},
			getList: function(param, query){
				return request({
					//url: 'work/alarmList',
					url: 'api/wAlarm',
					method: 'get',
					data:query,
					params:param
				})
			},
			/* 更新 */
			updateItem: function(data){
				return request({
					//url: 'work/alarm',
					url: 'api/wAlarm',
					method: 'PUT',
					data:data,
				})
			},
			// 统计
			getCount: function(param, query){
				return request({
					url: 'work/alarmCount',
					method: 'get',
				})
			},
		},
		users:{
			/* 获取 */
			getCount: function(param, query){
				return request({
					url: 'biz/usersCount',
					method: 'get',
				})
			},
			/* 获取 */
			getNotActiveCount: function(param, query){
				return request({
					url: 'biz/notActiveCount',
					method: 'get',
				})
			},
		},
		/* 导出Excel */
		export:{
			historyRecord: function(param, query){
				return request({
					url: 'export/history',
					method: 'get',
					data:query,
					params:param
				})
			},
			historyExport: function(param, query){
				return request({
					url: 'api/wHistory/download',
					method: 'get',
					data:query,
					params:param
				})
			},
		},
	};
};

var Dates = function(){
	/* 
		Dates.format('yyyy-MM-dd EE HH:mm:ss')
		Dates.format.call(new Date(), 'yyyy-MM-dd EE HH:mm:ss')
	*/
	var format = function(fmt){
		var Date_ = this.getDate ? this : new Date();
		var o = {           
		"M+" : Date_.getMonth()+1, //月份           
		"d+" : Date_.getDate(), //日           
		"h+" : Date_.getHours()%12 == 0 ? 12 : Date_.getHours()%12, //小时           
		"H+" : Date_.getHours(), //小时           
		"m+" : Date_.getMinutes(), //分           
		"s+" : Date_.getSeconds(), //秒           
		"q+" : Math.floor((Date_.getMonth()+3)/3), //季度           
		"S" : Date_.getMilliseconds() //毫秒           
		};           
		var week = {           
		"0" : "\u65e5",           
		"1" : "\u4e00",           
		"2" : "\u4e8c",           
		"3" : "\u4e09",           
		"4" : "\u56db",           
		"5" : "\u4e94",           
		"6" : "\u516d"          
		};           
		if(/(y+)/.test(fmt)){           
			fmt=fmt.replace(RegExp.$1, (Date_.getFullYear()+"").substr(4 - RegExp.$1.length));           
		}           
		if(/(E+)/.test(fmt)){           
			fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "\u661f\u671f" : "\u5468") : "")+week[Date_.getDay()+""]);           
		}           
		for(var k in o){           
			if(new RegExp("("+ k +")").test(fmt)){           
				fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));           
			}           
		}           
		return fmt;
	}
	
	var getDayStamp = function(){
		var start = new Date(new Date().toLocaleDateString()).getTime() / 1000;
		var end = ~~(new Date().getTime() / 1000);
		return {start:start, end:end};
	}

	return {format:format, getDayStamp:getDayStamp,}
};


var Tools = function(){
	var elementCompare = function(origin, target){
		var elCheck = Object.prototype.toString, stringEx = (origin.parentNode && origin.nodeType === 1 && target.nodeType === 1) && elCheck.call(origin) || 0;
		if(!stringEx) return dc;
		while(stringEx !== elCheck.call(target)){
			target = target.parentNode;
		}; return target;
	};
	var viewSwitch = function(controlCtn, tagName, viewCtn, activ, index, fn){
		if(!controlCtn.children){
			return;
		}
		var change, views = viewCtn.children, navChange;
		if(controlCtn && typeof controlCtn.nodeName === 'string'){
			var triggers = controlCtn.children, len = triggers.length;
			for(var i=0; i<len; i++){
				var trigger = triggers[i],
					dataset = trigger.dataset;
				dataset ? dataset.id = i : trigger.setAttribute('data-id', i)
			};
			navChange = function(id){
				var fcs = controlCtn.querySelector('.'+activ);
				fcs && fcs.classList.remove(activ);
				triggers[id].classList.add(activ);
			};
			controlCtn.onclick = function(e){
				var tag = e.target || e.srcElement;
				if(tag.nodeName === tagName){
					var item = elementCompare(triggers[0], tag);
					var id = item.dataset && item.dataset.id || item.getAttribute('data-id');
					if(!isNaN(id))change(id)
				}
			};
		};
		(change = function(id){
			id = id * 1;
			if(id == null || isNaN(id)) return console.log('viewSwitch index not is number');
			navChange && navChange(id);
			// content box
			var cfcs = viewCtn.querySelector('div.'+activ), view = views[id];
			cfcs && cfcs.classList.remove(activ);
			view.classList.add(activ);
			fn && fn(id, view)
		})(index);
		return change
	};
	
	/**
	  * 注册移动事件
	  * @param: {Object} opts [top, left, eventOutClose(事件超出容器后关闭, 默认false), showCloseBtn(默认false)]
	  * @param: {HTML} html [strHtml]
	  *	@example1: var slider = moveEvent.register({
						eventEl:canvas,
						disc:'x',
						event:true,
						start: function(e){
							mouseDewn = true;
							that.destX = 0;
						},
						move: function(e){if(mouseDewn){}else{};},
						end: function(e){if(mouseDewn){};},
						dblclick: function(e){},
						click: function(e){},
					});
	  * @author: Kimber
	  * @return: 
	  * @updatetime: 2021/6/18
	  */
	var moveEvent = function(opts){
		var register = function(opts){
			var eventEl = opts.eventEl;
			var sX, sY, estamp, isrMove = !opts.event;
			var addRelationEvent = function(type, fn){
				eventEl.addEventListener(type, fn, false);
			}, removeRelationEvent = function(type, fn){
				eventEl.removeEventListener(type, fn, false);
			};
			var sliderEvent = function(){
				this.eventHandler = function(that){
					this.eventTrigger = function(){
						addRelationEvent('mousemove', that);
						addRelationEvent('mouseup', that);
						//addRelationEvent('mouseout', that);
						//addRelationEvent('mouseover', that);
						addRelationEvent('mouseleave', that);
					};
					this.eventRemove = function(){
						removeRelationEvent('mousemove', that);
						removeRelationEvent('mouseup', that);
						//removeRelationEvent('mouseout', that);
						//removeRelationEvent('mouseover', that);
						removeRelationEvent('mouseleave', that);
					};
					this.addEvent = function(){
						addRelationEvent('mousedown', that)
					};
					this.removeEvent = function(){
						removeRelationEvent('mousedown', that)
					};
					return this
				}.call({}, this);
				this.eventHandler.addEvent();
				opts.event && this.eventHandler.eventTrigger();
			}; sliderEvent.prototype = {
				handleEvent : function(e){;
					switch(e.type){
						case 'mousedown' : this.start(e); break;
						case 'mousemove' : this.move(e); break;
						case 'mouseup' : 
						case 'mouseout' : 
						case 'mouseover' : 
						case 'mouseleave' : this.end(e); break;
					}
				},
				start: function(e){
					sX = e.pageX, sY = e.pageY;
					if(e.timeStamp - estamp < 280 && this.sX === sX && this.sY === sY){
						this.isDb = !this.isDb;
						clearTimeout(this.timeout);
						opts.dblclick && opts.dblclick(e);
					}else{
						opts.start && opts.start(e);
					};
					this.sX = sX;
					this.sY = sY;
					estamp = e.timeStamp;
					!opts.event && this.eventHandler.eventTrigger() || (isrMove = true);
				},
				move: function(e){
					if(isrMove){
						if(opts.disc){
							if(opts.disc === 'y'){
								e.destY = e.pageY - this.sY
							}else{
								e.destX = e.pageX - this.sX
							};
						}else{
							e.destX = e.pageX - this.sX;
							e.destY = e.pageY - this.sY;
						};
					}; opts.move && opts.move(e);
				},
				end: function(e){
					var that = this;
					opts.end && opts.end(e);
					!opts.event && this.eventHandler.eventRemove() || (isrMove = false);
					if(opts.click){
						if(e.type === 'mouseup' && e.timeStamp - estamp < 180 && this.sX === e.pageX && this.sY === e.pageY){
							clearTimeout(this.timeout);
							this.timeout = setTimeout(function(){
								if(that.isDb){
									that.isDb = !that.isDb
								}else{
									opts.click(e);
								};
							}, 150);
						};
					};
				},
			};
			return new sliderEvent()
		};
		var remove = function(sliderEvent){
			sliderEvent && sliderEvent.eventHandler.removeEvent()
		};
		return {register:register, remove:remove};
	};
	
	/**
	  * 元素滑动事件
	  * @param: {Object} opts [top, left, eventOutClose(事件超出容器后关闭, 默认false), showCloseBtn(默认false)]
	  * @param: {HTML} html [strHtml]
	  *	@example1: var slider = registerSlider(canvas, {
						disc:'x',
						event:true,
						start: function(e){
							mouseDewn = true;
							that.destX = 0;
						},
						move: function(e){if(mouseDewn){}else{};},
						end: function(e){if(mouseDewn){};},
					});
	  * @author: Kimber
	  * @return: 
	  * @updatetime: 2021/6/18
	  */
	var registerSlider = function(element, opts){
		var el = typeof element === "string" ? document.getElementById(element) : element;
		if(!el) return console.log('sliderPlate Error Element is a invalid param! ');

		var tagel = opts.tag || el;
		var left, top, moveX, moveY, dpr = 1;
		var addRelationEvent = function(el, type, fn){
			el.addEventListener(type, fn, false);
		}, removeRelationEvent = function(el, type, fn){
			el.removeEventListener(type, fn, false);
		};
		var slider = function(){
			this.eventHandler = function(that){
				this.eventTrigger = function(){
					addRelationEvent(el, 'mousemove', that);
					addRelationEvent(el, 'mouseup', that);
					//addRelationEvent(el, 'mouseout', that);
					//addRelationEvent(el, 'mouseover', that);
					addRelationEvent(el, 'mouseleave', that);
				};
				this.clearTrigger = function(){
					removeRelationEvent(el, 'mousemove', that);
					removeRelationEvent(el, 'mouseup', that);
					//removeRelationEvent(el, 'mouseout', that);
					//removeRelationEvent(el, 'mouseover', that);
					removeRelationEvent(el, 'mouseleave', that);
				};
				this.addEvent = function(){
					addRelationEvent(el, 'mousedown', that)
				};
				this.removeEvent = function(){
					removeRelationEvent(el, 'mousedown', that)
				}; return this
			}.call({}, this);

			return this.init()
		}; slider.prototype = {
			handleEvent : function(e){;
				switch(e.type){
					case 'mousedown' : this.start(e); break;
					case 'mousemove' : this.move(e); break;
					case 'mouseup' : 
					case 'mouseout' : 
					case 'mouseover' : 
					case 'mouseleave' : this.end(e); break;
				}
			},
			init: function(){
				this.eventHandler.addEvent();
				this.backopts = {eventHandler:this.eventHandler, setMoveAbs:this.setMoveAbs, setEndAbs:this.setEndAbs};
				opts.init && opts.init(this.backopts);
				return this.backopts
			},
			start: function(e){
				this.startX = e.pageX;
				this.startY = e.pageY;
				this.eventHandler.eventTrigger();
				opts.start && opts.start(e)
			},
			move: function(e){
				e.distX = (e.pageX - this.startX) * dpr;
				e.distY = (e.pageY - this.startY) * dpr;
				opts.move && opts.move(e)
			},
			end: function(e){
				this.eventHandler.clearTrigger();
				e.distX = (e.pageX - this.startX) * dpr;
				e.distY = (e.pageY - this.startY) * dpr;
				opts.end && opts.end(e)
			},
			setMoveAbs: function(x, y){
				if(x){
					(this || tagel).style.left = '';
				};
				if(y){
					(this || tagel).style.top = '';
				};
				(this || tagel).style['transform'] = 'translate('+x+'px, '+y+'px)' + 'translateZ(0)';
			},
			setEndAbs: function(x, y){
				(this || tagel).style['transform'] = '';
				(this || tagel).style.left = x + 'px';
				(this || tagel).style.top = y + 'px';
			},
		};
		return new slider()
	};

	var removeMoveEvent = function(slider){
		slider && slider.eventHandler.removeEvent()
	};

	return {viewSwitch:viewSwitch, moveEvent:moveEvent(), removeMoveEvent:removeMoveEvent, registerSlider:registerSlider}
};

/**
  * 地图初始化
  * @param: {Object} opts
  *	@example1: 
  * @createtime: 2021/7/2
  */
var CAMap = function(){
	var initMap = function(opts){
		// normal(标准), dark(幻影黑), light(月光银), whitesmoke(远山黛), fresh(草色青), grey(雅士灰), graffiti(涂鸦), macaron(马卡龙), blue(靛青蓝), darkblue(极夜蓝), wine(酱籽)

		var map = new AMap.Map(opts.container, {
			//mask: mask,
			// center: [120.651884,36.962533],
			center: [122.065951,37.487842],
			viewMode: '2D',		// viewMode: '3D',
			//layers: [new AMap.TileLayer.Satellite()],		// 卫星地图
			showLabel: true,
			labelzIndex: 130,
			pitch: 40,
			zoom: opts.zoom || 6,
			mapStyle: 'amap://styles/darkblue',
		});
		this.map = map;
		this.marker = {
			red1:'https://webapi.amap.com/theme/v1.3/markers/n/mark_rs.png',
			red2:'https://a.amap.com/jsapi_demos/static/demo-center/icons/poi-marker-red.png',
			Default1:'https://webapi.amap.com/theme/v1.3/markers/n/mark_bs.png',
			Default2:'https://a.amap.com/jsapi_demos/static/demo-center/icons/poi-marker-default.png',
		};

		return this
	};initMap.prototype = {
		/**
		  * 添加标记点
		  * @param: {Arrar} arr
		  *	@example1: this.cAMap.addMarkers([{lng:item.lng, lat:item.lat}]);
		  * @return: [marker]
		  * @createtime: 2021/7/2
		  */
		addMarkers: function(arr){
			var len = arr.length;
			var markers = [];
			for(var i=0; i<len; i++){
				var obj = arr[i];
				var marker = new AMap.Marker({
					//icon,
					position: [obj.lng, obj.lat],
					//offset: new AMap.Pixel(devX, devX),
					title: obj.name,
					/* label: {
						deviceid: obj.deviceid,
						name: obj.name,
						online: obj.online
					} */
				});
				markers.push(marker);
			};
			this.map.add(markers);
			return markers
		},
		/**
		  * 设置中心点
		  * @param: {Arrar} arr
		  *	@example1: this.cAMap.setCenter([lng, lat]);
		  * @createtime: 2021/7/2
		  */
		setCenter: function(arr){
			this.map.setCenter(arr)
		}
	};
	return initMap
};


/**
  * 文件下载
  * @return: Object
  * @author: Kimber
  * @updatetime: 2021/7/20
  * @createtime: 2021/7/20
  */
var FileStream = function(){
	function s2ab(s) {
		var buf = new ArrayBuffer(s.length);
		var view = new Uint8Array(buf);
		for (var i = 0; i != s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
		return buf;
	};

	/**
	  * 字符转换 Blob 对象
	  * @param: {String} str 
	  * @example1: var aaa = FileStream.toBlob(str);
	  * @return: 
	  * @author: Kimber
	  * @updatetime: 2021/7/20
	  * @createtime: 2021/7/20
	  */
	var toBlob = function(str){
		return new Blob([s2ab(str)], {
			type: "application/octet-stream"
		});
	};
	
	/**
	  * 利用 A标签 下载文件
	  * @param: {Blob} url 
	  * @param: {String} saveName	// 文件名
	  * @example1: FileStream.download(blob, 'Test.xlsx');
	  * @return: 
	  * @author: Kimber
	  * @updatetime: 2021/7/20
	  * @createtime: 2021/7/20
	  */
	var download = function(url, saveName){
		if (typeof url == 'object' && url instanceof Blob) {
			url = URL.createObjectURL(url); // 创建blob地址
		}
		var aLink = document.createElement('a');
		aLink.href = url;
		aLink.download = saveName || ''; // HTML5新增的属性，指定保存文件名，可以不要后缀，注意，file:///模式下不会生效
		var event;
		if (window.MouseEvent) event = new MouseEvent('click');
		else {
			event = document.createEvent('MouseEvents');
			event.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
		}
		aLink.dispatchEvent(event);
	};

	return {toBlob:toBlob, download:download}
};


export var HttpReq = HttpReq();
export var Dates = Dates();
export var Tools = Tools();
export var CAMap = CAMap();
export var FileStream = FileStream();


/* exports = {
	HttpReq: HttpReq(),
	Dates: Dates(),
	Tools: Tools(),
}; */

// WEBPACK FOOTER //
// ./src/common/js/common.js