import { extend } from 'dayjs';
import axios from 'axios';
import type { IArea, ItablePagination } from '../views/AlgorithmConfiguration/index';
import { localStg } from '@/utils/storage';
import { useRouter } from 'vue-router';
import { useMessage } from 'naive-ui';
import { Windows } from '@vicons/fa';


axios.defaults.baseURL = '/v1';

const router = useRouter();
const message = useMessage();

// const resetRouter = () => {
//   return window.href = '/login';
// };


const gloabalReqErrorMsg = (e) => {

  switch (e.code) {
    case "ERR_BAD_REQUEST":
      return window.$message.error("权限过期！")
  }


}


axios.interceptors.request.use((req) => {


  let token = localStg.get('token');

  if (token) req.headers['token'] = `${token}`;

  // let whiteRouteList = ['login']

  // for(let r of whiteRouteList) {

  // }

  return req;
}, (e) => Promise.reject(e));



axios.interceptors.response.use((res) => {
  console.log('------------------------- res', res)
  if (res.status === 401) {
    window.location.href = '/login'
  };
  return res;

}, (e) => {
  window.location.href = '/login'
});



//  区域 - 查
export const api_getAreaNode = async (): Promise<any> => await axios.get('/menus/tree');

// 区域 - 增
export const api_addAreaNode = async (data: IArea): Promise<any> => await axios.post('/menus', data);

// 区域 - 改
export const api_modifyAreaNode = async (data: IArea): Promise<any> => await axios.put('/menus', data);

// 区域 - 删
export const api_deleteAreaNode = async (id: number | string): Promise<any> => await axios.delete(`/menus/${id}`);

// 区域 = 查
export const api_getCameras = async (): Promise<any> => await axios.get(`/menus`);

// 摄像头 - 查
export const api_getCameraList = async (params: ItablePagination): Promise<any> =>
  await axios.get(`/cameras/page`, { params });

// 摄像头 - 增
export const api_addCameras = async (data: any): Promise<any> => await axios.post(`/cameras`, data);

// 摄像头 - 改
export const api_modifyCameras = async (data: any): Promise<any> => await axios.put(`/cameras`, data);

// 摄像头 - 删
export const api_delCameras = async (id: any): Promise<any> => await axios.delete(`/cameras/${id}`);

// 模板下载
export const api_downWebCam = async (id: string): Promise<any> => await axios.get(`/export/${id}`);

// 导出 - blob
export const api_exportBlobFile = async (ids: string): Promise<any> =>
  await axios.get(`/export/${ids}`, { responseType: 'blob' });

// 文件上传 - base64 -> ip
export const api_base64ToWebURl = async (image: string): Promise<any> => await axios.post(`/common/image`, { image });

// 算法 - 查
export const api_algorithms = async (params: ItablePagination): Promise<any> =>
  axios.get(`/algorithms/page`, { params });

// 算法 - 改
export const api_modifyAlgorithms = async (id: string, grade: string): Promise<any> =>
  axios.put(`/algorithms/${id}/${grade}`);

// ============================================================================================ 新增分析任务
// ================ 临时 | S
interface IAnalyItemParam {
  algorithmId: number | string;
  algorithmName: string;
  cameraIds?: any[];
  [key: string]: any;
}

// 修改类
interface IModifyTaskParam {
  id: string;
  isGrab: string;
  status: string;
  taskName: string;
  timeInterval: string;
  transcribeTime: string;
  videoVo: IAnalyItemParam[];
}


// ================ 临时 | E

// 新增类
type IAddTaskParam = IModifyTaskParam;

// 视频分析任务-新增任务
export const api_addTask = async (data: IAddTaskParam): Promise<any> => axios.post(`/videos`, data);

// 视频分析任务-编辑任务
export const api_modifyTask = async (data: IModifyTaskParam): Promise<any> => axios.put(`/videos`, data);

// 视频分析任务分页查询
export const api_getTask = async (data: ItablePagination): Promise<any> =>
  axios.get(`/videos/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&taskName=${data.taskName}`);

// 视频分析任务-单删
export const api_delTask = async (id: string): Promise<any> => axios.delete(`/videos/${id}`);

// 视频分析任务-变更任务状态
export const api_modifyTaskStatus = async (id: string, status: string): Promise<any> =>
  axios.put(`/videos/${id}/${status}`);

// 视频分析任务 - 单条数据
export const api_findModifyTaskInfo = async (id: string): Promise<any> => axios.get(`/videos/${id}`);


// ================================================================================= 报警分页日志查询 | S
interface IAlarmLogParam {
  algorithmGrade?: string;
  algorithmName?: string;
  pageNum?: string;
  pageSize?: string;
  resourceNo?: number;
  status?: string;
}


// 获取报警日志
export const api_getAlarmLog = async (params: IAlarmLogParam): Promise<any> => axios.get(`/alarm/logs/page`, { params });


// 删除日志记录
export const api_delAlarmLog = async (id: string): Promise<any> => axios.delete(`/alarm/logs/${id}`);

// 修改报警日志状态
export const api_modifyAlarmLog = async (id: string, status: string): Promise<any> => axios.put(`/alarm/logs/${id}/${status}`);


// ================================================================================= 报警分页日志查询 | E

interface IPushParamTask {
  id?: string;
  videoTaskId?: string;
  videoTaskName?: string;
}




interface IPushParamResult {
  contentName?: string;
  contentRemark?: string;
  id?: string;
  pushId?: string;
}




interface IPushParamCamera {
  contentName: string;
  contentRemark: string;
  id: string;
  pushId: string;
}




interface IPushParamAlgorithm {
  contentName: string;
  contentRemark: string;
  id: string;
  pushId: string;
}



interface IPushParam {
  algorithmList?: IPushParamAlgorithm[],
  cameraList?: IPushParamCamera[],
  id?: string;
  pushAddress?: string;
  pushName?: string;
  resultList?: IPushParamResult[],
  status?: string;
  videoTaskVoList?: IPushParamTask[]
}



// 新增报警推送
export const api_addAlarmPush = async (data: IPushParam) => {
  return await axios.post(`/pushs`, data)
};

// 修改报警推送
export const api_modifyAlarmPush = async (data: IPushParam) => {
  return await axios.put(`/pushs`, data)
};

// 报警推送查单全部
export const api_findPushItem = async (id) => {
  return await axios.get(`/pushs/${id}`)
}

// 推送删除
export const api_delPushItem = async (id) => {
  return await axios.delete(`/pushs/${id}`)
}

// 算法信息
export const api_getKeyOfAnaly = async () => {
  return await axios.get(`/pushs/algorithm`)
};

// 视频源信息
export const api_getKeyOfVideoSource = async () => {
  return await axios.get(`/pushs/camera`)
};

// 视频任务信息
export const api_getKeyTaskInfo = async () => {
  return await axios.get(`/pushs/video_task`)
};



// 推送 - 测试
export const api_test = async () => {
  return await axios.get('/pushs/test')
}


// 视频推送 - 视频任务列表
export const api_videoTaskKey = async () => {
  return await axios.get(`/videos/list`)
}


// 视频推送 - 分页查询
export const api_pushList = async (data) => {
  return await axios.get(`/pushs/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}`)
}

// ===================================================== 报警提醒 | E

// 报警提醒 - 算法列表
export const api_algorithmsList = async () => {
  return await axios.get(`/algorithms/list`)
}


interface popUpsConfigParam {
  ids: string;
  isRemind: string;
  isVoice: string;
  reminderType: string;
}

// 报警提醒 - 修改弹窗相关配置
export const api_algorithmsPopUpsConfig = async (data: popUpsConfigParam) => {
  await axios.put(`/algorithms/popUps`, data)
}


// 算法提醒 - 分页查询

export const api_algorithmsPopUpsPage = async (data: any) => {
  return await axios.get(`/algorithms/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}`)
}


// 算法提醒 - 修改弹窗配置回显
export const api_algorithmsPopUpsFind = async () => {
  // /algorithms/list
  return await axios.get(`/algorithms/list`)
}


// 算法提醒 - 删除语音
export const api_algorithmsPopUpsDel = async (id: string) => {
  return await axios.put(`/algorithms/audio/${id}`)
}

// 视频回放 - 临时测试
// /videos/test
export const api_videoTest = async () => {
  return await axios.get(`/videos/test`)
}


// ========================================================= 用户角色管理 | S

// 用户分页查询
export const api_userList = async (data: any) => {
  return await axios.get(`/users/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}&userName=${data.userName}`)
}

// 新增用户
export const api_addUserInfo = async (data: any) => {
  return await axios.post(`/users`, data)
}


// 修改用户信息
export const api_modifyUserInfo = async (data: any) => {
  return await axios.put(`/users`, data)
}


// 删除用户信息
export const api_delUserInfo = async (id: string) => {
  return await axios.delete(`/users/${id}`)
}


// 修改密码
export const api_modifyUserPass = async (id: string, password: string) => {
  return await axios.put(`/users/${id}/${password}`)
}


// 查询角色管理
export const api_roleList = async () => {
  return await axios.get('/roles/list')
}

// ======================================================== 角色管理 | E

interface IRoleParam {
  permissions?: string;
  roleName?: string;
  roleRemark?: string;
}

// 新增角色
export const api_addRole = async (data: IRoleParam) => {
  return await axios.post('/roles', data)
}

// 查询角色详情
export const api_findfRoleInfo = async (id: string) => {
  return await axios.post(`/roles/${id}`)
}

// ============================== 音视频相关 | S


// 音频文件
export const getAudioFile = async (audioId: string) => {
  return await axios.get(`/play/${audioId}`)
  // return await axios.get(`/play/${audioId}?audioId=${audioId}`)
}


// 视频文件
export const getVideoFile = async (fileName: string) => {
  return await axios.get(`/playVideo/${fileName}`)
}


// 修改角色信息
export const api_modifyRoleInfo = async (data: any) => {
  return await axios.put(`/roles`, data)
}


// 删除角色
export const api_delRoleInfo = async (id: string) => {
  return await axios.delete(`/roles/${id}`)
}


// 权限 - 权限树列表
export const api_permissionTreeList = async () => {
  return await axios.get(`/permission/tree`)
}

// ======================================== 首页 - /datas/points-count
export const api_pointsCount = async () => {
  return await axios.get(`/datas/points-count`)
}


export const api_taskCount = async () => {
  return await axios.get(`/datas/task-count`)
}



export const api_logCount = async (date) => {
  return await axios.get(`/datas/log-count/${date[0]}/${date[1]}`)
}


// ================================= 登录注册

// 登录
export const api_login = async (data: any) => {
  return await axios.post('/logins/login', data)
}

// 权限查询
export const api_permission = async () => {
  return await axios.get('/logins/list')
}


// 查询详情

// /v1/roles/{id}
export const api_roleInfo = async (id: string) => {
  return axios.get(`/roles/${id}`)
}

// 视频任务分析 - 接口
export const api_videosPage = async (data) => {
  return axios.get(`/videos/page?pageNum=${data.pageNum}&pageSize=${data.pageSize}`)
}


// 报警累计

export const api_getAlarmResultData = async () => {
  return axios.get(`/datas/day`)
}


// 根据ID查询信息
export const api_getUserInfo = async (id: string) => {
  return axios.get(`/users/${id}`)
}
