// 数组过滤器
export function filterArray(arr, criteria) {
  return arr.filter(item => {
      return Object.keys(criteria).every(key => item[key] === criteria[key]);
  });
}
//版本号升级
export function updateVersion(version, level) {
  // 将版本号字符串分割成数组
  let versionParts = version.split('.').map(Number);
  // 根据传入的 level 值更新相应的版本号部分
  switch(level) {
      case 1:
          versionParts[0] += 1; // 增加主版本号
          versionParts[1] = 0; // 次版本号归零
          versionParts[2] = 0; // 修订号归零
          break;
      case 2:
          versionParts[1] += 1; // 增加次版本号
          versionParts[2] = 0; // 修订号归零
          break;
      case 3:
          versionParts[2] += 1; // 增加修订号
          break;
      default:
          throw new Error('版本号格式不正确，应为 x.x.x，必须是数字，比如1.2.1');
  }

  // 将版本号数组转换回字符串格式
  return versionParts.join('.');
}
//数组提取特殊字段用于table/select显示
export function transformArray(arr, valueField, labelField) {
    return arr.map(item => ({
        value: item[valueField],
        label: item[labelField]
    }));
}
//将对应value值显示
export function findLabelByValue(arr, value) {
    const found = arr.find(item => item.value === value);
    return found ? found.label : undefined;
}
// 选择特定字段和重命名字段
export function selectAndRenameArrayFields(originalArray, selectedFields, newFieldNames = []) {
  return originalArray.map(item => {
    const newItem = {};
    selectedFields.forEach((field, index) => {
      const newFieldName = newFieldNames[index] || field;
      newItem[newFieldName] = item[field];
    });
    return newItem;
  });
}
//轮播展示的数据分组
export const generateCarouselItems = (arr, itemsPerGroup) => {
  const totalGroups = Math.ceil(arr.length / itemsPerGroup);
  const result = [];
  for (let i = 0; i < totalGroups; i++) {
    const startIndex = i * itemsPerGroup;
    const endIndex = startIndex + itemsPerGroup;
    result.push(arr.slice(startIndex, endIndex));
  }
  return result;
};